/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.sort.IntIterator;

public class IntHashSet
implements Serializable {
    private static final int NBIT = 30;
    public static final int MAX_SIZE = 0x40000000;
    public final int ndv;
    private double _factor;
    private int _nmax;
    private int _size;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _values;

    public IntHashSet() {
        this(8, 0.25, Integer.MIN_VALUE);
    }

    public IntHashSet(int n2) {
        this(n2, 0.25, Integer.MIN_VALUE);
    }

    public IntHashSet(int n2, int n3) {
        this(n2, 0.25, n3);
    }

    public IntHashSet(int n2, double d2, int n3) {
        this.ndv = n3;
        this._factor = d2;
        this.setCapacity(n2);
    }

    public void clear() {
        this._size = 0;
        for (int i2 = 0; i2 < this._nmax; ++i2) {
            this._values[i2] = this.ndv;
        }
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int peek(int n2) {
        for (int i2 = 0; i2 < this._values.length; ++i2) {
            if (this._values[i2] == this.ndv) continue;
            return this._values[i2];
        }
        return n2;
    }

    public int[] getValues() {
        int n2 = 0;
        int[] nArray = new int[this._size];
        for (int i2 = 0; i2 < this._values.length; ++i2) {
            if (this._values[i2] == this.ndv) continue;
            nArray[n2++] = this._values[i2];
        }
        return nArray;
    }

    public boolean contains(int n2) {
        return this._values[this.indexOf(n2)] != this.ndv;
    }

    public boolean remove(int n2) {
        int n3 = this.indexOf(n2);
        if (this._values[n3] == this.ndv) {
            return false;
        }
        --this._size;
        while (true) {
            int n4;
            this._values[n3] = this.ndv;
            int n5 = n3;
            do {
                if (this._values[n3 = n3 - 1 & this._mask] != this.ndv) continue;
                return true;
            } while (n3 <= (n4 = this.hash(this._values[n3])) && n4 < n5 || n4 < n5 && n5 < n3 || n5 < n3 && n3 <= n4);
            this._values[n5] = this._values[n3];
        }
    }

    public boolean add(int n2) {
        if (n2 == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int n3 = this.indexOf(n2);
        if (this._values[n3] == this.ndv) {
            ++this._size;
            this._values[n3] = n2;
            if (this._size > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this._nlo < this._size && this._size <= this._nhi) {
                this.setCapacity(this._size);
            }
            return true;
        }
        return false;
    }

    private int hash(int n2) {
        return 1327217885 * n2 >> this._shift & this._mask;
    }

    private int indexOf(int n2) {
        int n3 = this.hash(n2);
        while (this._values[n3] != this.ndv) {
            if (this._values[n3] == n2) {
                return n3;
            }
            n3 = n3 - 1 & this._mask;
        }
        return n3;
    }

    private void setCapacity(int n2) {
        int n3;
        if (n2 < this._size) {
            n2 = this._size;
        }
        double d2 = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int n4 = 1;
        for (n3 = 2; (double)n3 * d2 < (double)n2 && n3 < 0x40000000; n3 *= 2) {
            ++n4;
        }
        int n5 = this._nmax;
        if (n3 == n5) {
            return;
        }
        this._nmax = n3;
        this._nlo = (int)((double)n3 * d2);
        this._nhi = (int)(1.073741824E9 * d2);
        this._shift = 31 - n4;
        this._mask = n3 - 1;
        this._size = 0;
        int[] nArray = this._values;
        this._values = new int[n3];
        Arrays.fill(this._values, this.ndv);
        if (nArray != null) {
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = nArray[i2];
                if (n6 == this.ndv) continue;
                ++this._size;
                this._values[this.indexOf((int)n6)] = n6;
            }
        }
    }

    public IntIterator iterator() {
        return new IntHashSetIterator();
    }

    public IntHashSet union(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size() + intHashSet.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intHashSet2.add(intIterator.next());
        }
        intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            intHashSet2.add(intIterator.next());
        }
        return intHashSet2;
    }

    public IntHashSet intersect(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (!intHashSet.contains(n2)) continue;
            intHashSet2.add(n2);
        }
        return intHashSet2;
    }

    public IntHashSet except(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (intHashSet.contains(n2)) continue;
            intHashSet2.add(n2);
        }
        return intHashSet2;
    }

    public boolean containsAll(IntHashSet intHashSet) {
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsSome(IntHashSet intHashSet) {
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            if (!this.contains(intIterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IntHashSet) {
            IntHashSet intHashSet = (IntHashSet)object;
            return this.size() == intHashSet.size() && this.containsAll(intHashSet);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 936247625;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n2 += intIterator.next();
        }
        return n2;
    }

    private class IntHashSetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            while (this.i < IntHashSet.this._values.length) {
                if (IntHashSet.this._values[this.i] != IntHashSet.this.ndv) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public int next() {
            return IntHashSet.this._values[this.i++];
        }
    }
}

