/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.sort.IntIterator;

public class IntHashMap
implements Serializable {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private double _factor;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private Object[] _value;

    public IntHashMap() {
        this(8, 0.25);
    }

    public IntHashMap(int n2) {
        this(n2, 0.25);
    }

    public IntHashMap(int n2, double d2) {
        this._factor = d2;
        this.setCapacity(n2);
    }

    public void clear() {
        this._n = 0;
        for (int i2 = 0; i2 < this._nmax; ++i2) {
            this._value[i2] = null;
        }
    }

    public Object get(int n2) {
        return this._value[this.indexOf(n2)];
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int n2) {
        int n3 = this.indexOf(n2);
        if (this._value[n3] == null) {
            return false;
        }
        --this._n;
        while (true) {
            int n4;
            this._value[n3] = null;
            int n5 = n3;
            do {
                if (this._value[n3 = n3 - 1 & this._mask] != null) continue;
                return true;
            } while (n3 <= (n4 = this.hash(this._key[n3])) && n4 < n5 || n4 < n5 && n5 < n3 || n5 < n3 && n3 <= n4);
            this._key[n5] = this._key[n3];
            this._value[n5] = this._value[n3];
        }
    }

    public void put(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException("IntHashMap does not allow null values");
        }
        int n3 = this.indexOf(n2);
        if (this._value[n3] != null) {
            this._value[n3] = object;
        } else {
            this._key[n3] = n2;
            this._value[n3] = object;
            this.grow();
        }
    }

    private int hash(int n2) {
        return 1327217885 * n2 >> this._shift & this._mask;
    }

    private int indexOf(int n2) {
        int n3 = this.hash(n2);
        while (this._value[n3] != null) {
            if (this._key[n3] == n2) {
                return n3;
            }
            n3 = n3 - 1 & this._mask;
        }
        return n3;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int n2) {
        int n3;
        if (n2 < this._n) {
            n2 = this._n;
        }
        double d2 = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int n4 = 1;
        for (n3 = 2; (double)n3 * d2 < (double)n2 && n3 < 0x40000000; n3 *= 2) {
            ++n4;
        }
        int n5 = this._nmax;
        if (n3 == n5) {
            return;
        }
        this._nmax = n3;
        this._nlo = (int)((double)n3 * d2);
        this._nhi = (int)(1.073741824E9 * d2);
        this._shift = 31 - n4;
        this._mask = n3 - 1;
        int[] nArray = this._key;
        Object[] objectArray = this._value;
        this._n = 0;
        this._key = new int[n3];
        this._value = new Object[n3];
        if (nArray != null) {
            for (int i2 = 0; i2 < n5; ++i2) {
                if (objectArray[i2] == null) continue;
                this.put(nArray[i2], objectArray[i2]);
            }
        }
    }

    public IntIterator keyIterator() {
        return new IntHashMapKeyIterator();
    }

    public Iterator valueIterator() {
        return new IntHashMapValueIterator();
    }

    public IntHashMap copy() {
        IntHashMap intHashMap = new IntHashMap(this.size());
        IntIterator intIterator = this.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            intHashMap.put(n2, this.get(n2));
        }
        return intHashMap;
    }

    public void display() {
        IntHashMapKeyIterator intHashMapKeyIterator = new IntHashMapKeyIterator();
        while (intHashMapKeyIterator.hasNext()) {
            int n2 = intHashMapKeyIterator.next();
            Object object = this.get(n2);
            System.err.println(n2 + " -> " + object.toString());
        }
    }

    private class IntHashMapValueIterator
    implements Iterator,
    Serializable {
        private IntHashMapKeyIterator k;

        public IntHashMapValueIterator() {
            this.k = new IntHashMapKeyIterator();
        }

        public boolean hasNext() {
            return this.k.hasNext();
        }

        public Object next() {
            return IntHashMap.this.get(this.k.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on IntHashMapValueIterator");
        }
    }

    private class IntHashMapKeyIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            while (this.i < IntHashMap.this._key.length) {
                if (IntHashMap.this._value[this.i] != null) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public int next() {
            return IntHashMap.this._key[this.i++];
        }
    }
}

