/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;

public class IntArraySet
implements Serializable {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] contents;
    private int hashCode = -1;

    public IntArraySet() {
        this.contents = EMPTY_INT_ARRAY;
    }

    public IntArraySet(IntHashSet intHashSet) {
        this.contents = intHashSet.getValues();
        Arrays.sort(this.contents);
    }

    public IntArraySet(IntArraySet intArraySet) {
        this.contents = new int[intArraySet.contents.length];
        System.arraycopy(intArraySet.contents, 0, this.contents, 0, this.contents.length);
    }

    public void clear() {
        this.contents = EMPTY_INT_ARRAY;
    }

    public int size() {
        return this.contents.length;
    }

    public boolean isEmpty() {
        return this.contents.length == 0;
    }

    public int[] getValues() {
        return this.contents;
    }

    public boolean contains(int n2) {
        return Arrays.binarySearch(this.contents, n2) >= 0;
    }

    public boolean remove(int n2) {
        int n3 = Arrays.binarySearch(this.contents, n2);
        if (n3 < 0) {
            return false;
        }
        int[] nArray = new int[this.contents.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.contents, 0, nArray, 0, n3);
        }
        if (n3 < nArray.length) {
            System.arraycopy(this.contents, n3 + 1, nArray, n3, this.contents.length - n3);
        }
        this.contents = nArray;
        return true;
    }

    public boolean add(int n2) {
        if (this.contents.length == 0) {
            int[] nArray = new int[]{n2};
            this.contents = nArray;
            return true;
        }
        int n3 = Arrays.binarySearch(this.contents, n2);
        if (n3 >= 0) {
            return false;
        }
        n3 = -n3 - 1;
        int[] nArray = new int[this.contents.length + 1];
        if (n3 > 0) {
            System.arraycopy(this.contents, 0, nArray, 0, n3);
        }
        nArray[n3] = n2;
        if (n3 < this.contents.length) {
            System.arraycopy(this.contents, n3, nArray, n3 + 1, nArray.length - n3);
        }
        this.contents = nArray;
        return true;
    }

    public int getFirst() {
        return this.contents[0];
    }

    public IntIterator iterator() {
        return new IntArraySetIterator();
    }

    public IntArraySet union(IntArraySet intArraySet) {
        if (this.size() == 0) {
            return new IntArraySet(intArraySet);
        }
        if (intArraySet.size() == 0) {
            return new IntArraySet(this);
        }
        if (this.equals(intArraySet)) {
            return this;
        }
        int[] nArray = new int[this.size() + intArraySet.size()];
        int[] nArray2 = this.contents;
        int[] nArray3 = intArraySet.contents;
        int n2 = nArray2.length;
        int n3 = nArray3.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        do {
            if (nArray2[n5] < nArray3[n6]) {
                nArray[n4++] = nArray2[n5++];
            } else if (nArray3[n6] < nArray2[n5]) {
                nArray[n4++] = nArray3[n6++];
            } else {
                nArray[n4++] = nArray2[n5++];
                ++n6;
            }
            if (n5 != n2) continue;
            System.arraycopy(nArray3, n6, nArray, n4, n3 - n6);
            return IntArraySet.make(nArray, n4 += n3 - n6);
        } while (n6 != n3);
        System.arraycopy(nArray2, n5, nArray, n4, n2 - n5);
        return IntArraySet.make(nArray, n4 += n2 - n5);
    }

    public static IntArraySet make(int[] nArray, int n2) {
        int[] nArray2;
        if (nArray.length == n2) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        return new IntArraySet(nArray2);
    }

    private IntArraySet(int[] nArray) {
        this.contents = nArray;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.contents.length * 4);
        for (int i2 = 0; i2 < this.contents.length; ++i2) {
            fastStringBuffer.append(this.contents[i2] + ",");
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IntArraySet) {
            IntArraySet intArraySet = (IntArraySet)object;
            return Arrays.equals(this.contents, intArraySet.contents);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n2 = 936247625;
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                n2 += intIterator.next();
            }
            this.hashCode = n2;
        }
        return this.hashCode;
    }

    private class IntArraySetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            return this.i < IntArraySet.this.contents.length;
        }

        public int next() {
            return IntArraySet.this.contents[this.i++];
        }
    }
}

