/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration config;
    private HashMap functions = new HashMap(20);

    public XQueryFunctionLibrary(Configuration configuration) {
        this.config = configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        int n2;
        int n3 = xQueryFunction.getFunctionFingerprint();
        Long l2 = XQueryFunctionLibrary.functionKey(n3, n2 = xQueryFunction.getNumberOfArguments());
        if (this.functions.get(l2) != null) {
            XQueryFunction xQueryFunction2 = (XQueryFunction)this.functions.get(l2);
            StaticError staticError = new StaticError("Duplicate definition of function " + this.getNamePool().getDisplayName(n3) + " (see line " + xQueryFunction2.getLineNumber() + " in " + xQueryFunction2.getSystemId() + ')');
            staticError.setErrorCode("XQST0034");
            staticError.setLocator(xQueryFunction);
            throw staticError;
        }
        this.functions.put(l2, xQueryFunction);
    }

    private static Long functionKey(int n2, int n3) {
        return new Long(((long)n3 << 32) + (long)n2);
    }

    public boolean isAvailable(int n2, String string, String string2, int n3) {
        if (n3 == -1) {
            for (int i2 = 0; i2 < 20; ++i2) {
                if (!this.isAvailable(n2, string, string2, i2)) continue;
                return true;
            }
            return false;
        }
        return this.functions.get(XQueryFunctionLibrary.functionKey(n2, n3)) != null;
    }

    public Expression bind(int n2, String string, String string2, Expression[] expressionArray) throws XPathException {
        int n3 = n2 & 0xFFFFF;
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n3, expressionArray.length));
        if (xQueryFunction != null) {
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            userFunctionCall.setFunctionNameCode(n2);
            userFunctionCall.setArguments(expressionArray);
            userFunctionCall.setStaticType(xQueryFunction.getResultType());
            UserFunction userFunction = xQueryFunction.getUserFunction();
            if (userFunction == null) {
                xQueryFunction.registerReference(userFunctionCall);
                userFunctionCall.setConfirmed(true);
            } else {
                userFunctionCall.setFunction(userFunction, xQueryFunction.getStaticContext());
                userFunctionCall.checkFunctionCall(userFunction, xQueryFunction.getStaticContext());
            }
            return userFunctionCall;
        }
        return null;
    }

    public XQueryFunction getDeclaration(int n2, String string, String string2, Expression[] expressionArray) {
        return (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n2 & 0xFFFFF, expressionArray.length));
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(StaticQueryContext staticQueryContext) throws XPathException {
        XQueryFunction xQueryFunction;
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.compile(staticQueryContext);
        }
        iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.checkReferences(staticQueryContext);
        }
    }

    public void explainGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.explain(this.getConfiguration());
        }
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n2) {
        int n3 = this.getNamePool().allocate("", string, string2) & 0xFFFFF;
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n3, n2));
        if (xQueryFunction == null) {
            return null;
        }
        return xQueryFunction.getUserFunction();
    }

    public FunctionLibrary copy() {
        XQueryFunctionLibrary xQueryFunctionLibrary = new XQueryFunctionLibrary(this.config);
        xQueryFunctionLibrary.functions = new HashMap(this.functions);
        return xQueryFunctionLibrary;
    }
}

