/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullNamespaceReducer
extends PullFilter
implements NamespaceResolver {
    private int[] allNamespaces = new int[50];
    private int allNamespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private int[] localNamespaces;
    private int localNamespacesSize = 0;
    private int nameCode;
    private NamespaceDeclarations declaredNamespaces;
    private AttributeCollection attributeCollection;
    private int[] pendingUndeclarations = null;
    private int[] nsBuffer = new int[20];

    public PullNamespaceReducer(PullProvider pullProvider) {
        super(pullProvider);
    }

    public int next() throws XPathException {
        int n2 = super.next();
        switch (n2) {
            case 4: {
                this.startElement();
                break;
            }
            case 5: {
                this.endElement();
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                this.nameCode = super.getNameCode();
                break;
            }
            default: {
                this.nameCode = -1;
            }
        }
        return n2;
    }

    private void startElement() throws XPathException {
        int n2;
        Object object;
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            object = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, object, 0, this.depth);
            this.countStack = (int[])object;
        }
        object = super.getNamespaceDeclarations();
        this.localNamespaces = object.getNamespaceCodes(this.nsBuffer);
        this.localNamespacesSize = 0;
        for (n2 = 0; n2 < this.localNamespaces.length && this.localNamespaces[n2] != -1; ++n2) {
            if (!this.isNeeded(this.localNamespaces[n2])) continue;
            this.addGlobalNamespace(this.localNamespaces[n2]);
            int n3 = this.depth - 1;
            this.countStack[n3] = this.countStack[n3] + 1;
            this.localNamespaces[this.localNamespacesSize++] = this.localNamespaces[n2];
        }
        this.nameCode = this.checkProposedPrefix(super.getNameCode(), 0);
        this.attributeCollection = super.getAttributes();
        n2 = 0;
        for (int i2 = 0; i2 < this.attributeCollection.getLength(); ++i2) {
            int n4;
            int n5 = this.attributeCollection.getNameCode(i2);
            if ((n5 & 0xFFF00000) == 0 || n5 == (n4 = this.checkProposedPrefix(n5, i2 + 1))) continue;
            if (n2 == 0) {
                this.attributeCollection = this.copyAttributeCollection(this.attributeCollection);
                n2 = 1;
            }
            ((AttributeCollectionImpl)this.attributeCollection).setAttribute(i2, n4, this.attributeCollection.getTypeAnnotation(i2), this.attributeCollection.getValue(i2), this.attributeCollection.getLocationId(i2), this.attributeCollection.getProperties(i2));
        }
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize] = -1;
        }
        this.declaredNamespaces = new NamespaceDeclarationsImpl(this.getNamePool(), this.localNamespaces);
        this.countStack[this.depth - 1] = this.localNamespacesSize;
    }

    private void addLocalNamespace(int n2) {
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize++] = n2;
        } else if (this.localNamespacesSize == 0) {
            this.localNamespaces = new int[10];
        } else {
            int[] nArray = new int[this.localNamespacesSize * 2];
            System.arraycopy(this.localNamespaces, 0, nArray, 0, this.localNamespacesSize);
            this.localNamespaces = nArray;
            this.localNamespaces[this.localNamespacesSize++] = n2;
        }
        this.addGlobalNamespace(n2);
    }

    private boolean isNeeded(int n2) {
        int n3;
        if (n2 == 65537) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (n3 = 0; n3 < this.pendingUndeclarations.length; ++n3) {
                if (n2 >> 16 != this.pendingUndeclarations[n3] >> 16) continue;
                this.pendingUndeclarations[n3] = -1;
            }
        }
        for (n3 = this.allNamespacesSize - 1; n3 >= 0; --n3) {
            if (this.allNamespaces[n3] == n2) {
                return false;
            }
            if (this.allNamespaces[n3] >> 16 != n2 >> 16) continue;
            return true;
        }
        return n2 != 0;
    }

    private int checkProposedPrefix(int n2, int n3) {
        NamePool namePool = this.getNamePool();
        int n4 = namePool.getNamespaceCode(n2);
        if (n4 == -1) {
            n4 = namePool.allocateNamespaceCode(n2);
        }
        int n5 = n4 >> 16;
        for (int i2 = this.allNamespacesSize - 1; i2 >= 0; --i2) {
            if (n5 != this.allNamespaces[i2] >> 16) continue;
            if ((n4 & 0xFFFF) == (this.allNamespaces[i2] & 0xFFFF)) {
                return n2;
            }
            if (i2 + this.localNamespacesSize >= this.allNamespacesSize) {
                String string = this.getSubstitutePrefix(n4, n3);
                int n6 = namePool.allocate(string, namePool.getURI(n2), namePool.getLocalName(n2));
                int n7 = namePool.allocateNamespaceCode(n6);
                this.addLocalNamespace(n7);
                return n6;
            }
            this.addLocalNamespace(n4);
            return n2;
        }
        if (n4 != 0) {
            this.addLocalNamespace(n4);
        }
        return n2;
    }

    private String getSubstitutePrefix(int n2, int n3) {
        String string = this.getNamePool().getPrefixFromNamespaceCode(n2);
        return string + '_' + n3;
    }

    private void addGlobalNamespace(int n2) {
        if (this.allNamespacesSize + 1 >= this.allNamespaces.length) {
            int[] nArray = new int[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, nArray, 0, this.allNamespacesSize);
            this.allNamespaces = nArray;
        }
        this.allNamespaces[this.allNamespacesSize++] = n2;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public AttributeCollection getAttributes() throws XPathException {
        return this.attributeCollection;
    }

    private AttributeCollectionImpl copyAttributeCollection(AttributeCollection attributeCollection) {
        AttributeCollectionImpl attributeCollectionImpl = new AttributeCollectionImpl(this.getNamePool());
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            attributeCollectionImpl.addAttribute(attributeCollection.getNameCode(i2), attributeCollection.getTypeAnnotation(i2), attributeCollection.getValue(i2), attributeCollection.getLocationId(i2), attributeCollection.getProperties(i2));
        }
        return attributeCollectionImpl;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        return this.declaredNamespaces;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int n2 = this.countStack[this.depth];
        this.allNamespacesSize -= n2;
    }

    protected short getURICode(short s2) {
        for (int i2 = this.allNamespacesSize - 1; i2 >= 0; --i2) {
            if (this.allNamespaces[i2] >> 16 != s2) continue;
            return (short)(this.allNamespaces[i2] & 0xFFFF);
        }
        if (s2 == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if ("".equals(string) && !bl) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s2 = namePool.getCodeForPrefix(string);
        short s3 = this.getURICode(s2);
        if (s3 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s3);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.allNamespacesSize);
        for (int i2 = this.allNamespacesSize - 1; i2 >= 0; --i2) {
            String string = namePool.getPrefixFromNamespaceCode(this.allNamespaces[i2]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

