/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class UnionPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeType = 0;

    public UnionPattern(Pattern pattern, Pattern pattern2) {
        this.p1 = pattern;
        this.p2 = pattern2;
        if (pattern.getNodeKind() == pattern2.getNodeKind()) {
            this.nodeType = pattern.getNodeKind();
        }
    }

    public Pattern simplify(StaticContext staticContext) throws XPathException {
        this.p1 = this.p1.simplify(staticContext);
        this.p2 = this.p2.simplify(staticContext);
        return this;
    }

    public Pattern analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.p1 = this.p1.analyze(staticContext, itemType);
        this.p2 = this.p2.analyze(staticContext, itemType);
        return this;
    }

    public void setOriginalText(String string) {
        super.setOriginalText(string);
        this.p1.setOriginalText(string);
        this.p2.setOriginalText(string);
    }

    public boolean matches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        return this.p1.matches(nodeInfo, xPathContext) || this.p2.matches(nodeInfo, xPathContext);
    }

    public int getNodeKind() {
        return this.nodeType;
    }

    public NodeTest getNodeTest() {
        if (this.nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.nodeType);
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }

    public void setSystemId(String string) {
        super.setSystemId(string);
        this.p1.setSystemId(string);
        this.p2.setSystemId(string);
    }

    public void setLineNumber(int n2) {
        super.setLineNumber(n2);
        this.p1.setLineNumber(n2);
        this.p2.setLineNumber(n2);
    }
}

