/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trans.DynamicError;

public class NamePool
implements Serializable {
    public static final int FP_MASK = 1048575;
    public static final int USER_DEFINED_MASK = 1047552;
    public static final int MAX_PREFIXES_PER_URI = 1023;
    private static NamePool defaultNamePool = new NamePool();
    NameEntry[] hashslots = new NameEntry[1024];
    String[] prefixes = new String[100];
    short prefixesUsed = 0;
    String[] uris = new String[100];
    String[][] prefixesForUri = new String[100][0];
    short urisUsed = 0;
    private HashMap clientData;

    public static NamePool getDefaultNamePool() {
        return defaultNamePool;
    }

    public static void setDefaultNamePool(NamePool namePool) {
        defaultNamePool = namePool;
    }

    public NamePool() {
        this.prefixes[0] = "";
        this.uris[0] = "";
        String[] stringArray = new String[]{""};
        this.prefixesForUri[0] = stringArray;
        this.prefixes[1] = "xml";
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        String[] stringArray2 = new String[]{"xml"};
        this.prefixesForUri[1] = stringArray2;
        this.prefixes[2] = "xsl";
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        String[] stringArray3 = new String[]{"xslt"};
        this.prefixesForUri[2] = stringArray3;
        this.prefixes[3] = "saxon";
        this.uris[3] = "http://saxon.sf.net/";
        String[] stringArray4 = new String[]{"saxon"};
        this.prefixesForUri[3] = stringArray4;
        this.prefixes[4] = "xs";
        this.uris[4] = "http://www.w3.org/2001/XMLSchema";
        String[] stringArray5 = new String[]{"xs"};
        this.prefixesForUri[4] = stringArray5;
        this.prefixes[5] = "xdt";
        this.uris[5] = "http://www.w3.org/2005/xpath-datatypes";
        String[] stringArray6 = new String[]{"xdt"};
        this.prefixesForUri[5] = stringArray6;
        this.prefixes[6] = "xsi";
        this.uris[6] = "http://www.w3.org/2001/XMLSchema-instance";
        String[] stringArray7 = new String[]{"xsi"};
        this.prefixesForUri[6] = stringArray7;
        this.prefixesUsed = (short)7;
        this.urisUsed = (short)7;
    }

    private NameEntry getNameEntry(int n2) {
        int n3 = n2 & 0x3FF;
        int n4 = n2 >> 10 & 0x3FF;
        NameEntry nameEntry = this.hashslots[n3];
        for (int i2 = 1; i2 < n4; ++i2) {
            if (nameEntry == null) {
                return null;
            }
            nameEntry = nameEntry.nextEntry;
        }
        return nameEntry;
    }

    public synchronized int allocateNamespaceCode(String string, String string2) {
        String[] stringArray;
        short s2 = this.allocateCodeForPrefix(string);
        short s3 = this.allocateCodeForURI(string2);
        if (s2 != 0 && ((stringArray = this.prefixesForUri[s3]).length == 0 || !stringArray[0].equals(string) && Arrays.asList(stringArray).indexOf(string) < 0)) {
            if (stringArray.length == 1023) {
                throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            this.prefixesForUri[s3] = stringArray2;
        }
        return (s2 << 16) + s3;
    }

    public int getNamespaceCode(String string, String string2) {
        String[] stringArray;
        short s2 = this.getCodeForPrefix(string);
        if (s2 < 0) {
            return -1;
        }
        short s3 = this.getCodeForURI(string2);
        if (s3 < 0) {
            return -1;
        }
        if (s2 != 0 && ((stringArray = this.prefixesForUri[s3]).length == 0 || !stringArray[0].equals(string) && Arrays.asList(stringArray).indexOf(string) < 0)) {
            return -1;
        }
        return (s2 << 16) + s3;
    }

    public int getNamespaceCode(int n2) {
        short s2;
        int n3 = n2 & 0xFFFFF;
        if ((n3 & 0xFFC00) == 0) {
            s2 = StandardNames.getURICode(n3);
        } else {
            NameEntry nameEntry = this.getNameEntry(n2);
            if (nameEntry == null) {
                return -1;
            }
            s2 = nameEntry.uriCode;
        }
        int n4 = NamePool.getPrefixIndex(n2);
        String string = this.getPrefixWithIndex(s2, n4);
        if (string == null) {
            return -1;
        }
        short s3 = this.getCodeForPrefix(string);
        if (s3 == -1) {
            return -1;
        }
        return (s3 << 16) + s2;
    }

    public static int getPrefixIndex(int n2) {
        return n2 >> 20 & 0x3FF;
    }

    public synchronized short allocateCodeForURI(String string) {
        for (short s2 = 0; s2 < this.urisUsed; s2 = (short)(s2 + 1)) {
            if (!this.uris[s2].equals(string)) continue;
            return s2;
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace URIs");
            }
            String[][] stringArray = new String[this.urisUsed * 2][0];
            String[] stringArray2 = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixesForUri, 0, stringArray, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, stringArray2, 0, this.urisUsed);
            this.prefixesForUri = stringArray;
            this.uris = stringArray2;
        }
        this.uris[this.urisUsed] = string;
        short s3 = this.urisUsed;
        this.urisUsed = (short)(s3 + 1);
        return s3;
    }

    public short getCodeForURI(String string) {
        for (short s2 = 0; s2 < this.urisUsed; s2 = (short)(s2 + 1)) {
            if (!this.uris[s2].equals(string)) continue;
            return s2;
        }
        return -1;
    }

    private short allocateCodeForPrefix(String string) {
        short s2 = 1;
        if (string.equals("")) {
            return 0;
        }
        if (string.charAt(0) != 'x') {
            if (string.equals("saxon")) {
                return 3;
            }
            s2 = 7;
        }
        for (short s3 = s2; s3 < this.prefixesUsed; s3 = (short)(s3 + 1)) {
            if (!this.prefixes[s3].equals(string)) continue;
            return s3;
        }
        if (this.prefixesUsed >= this.prefixes.length) {
            if (this.prefixesUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace prefixes");
            }
            String[] stringArray = new String[this.prefixesUsed * 2];
            System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixesUsed);
            this.prefixes = stringArray;
        }
        this.prefixes[this.prefixesUsed] = string;
        short s4 = this.prefixesUsed;
        this.prefixesUsed = (short)(s4 + 1);
        return s4;
    }

    public short getCodeForPrefix(String string) {
        for (short s2 = 0; s2 < this.prefixesUsed; s2 = (short)(s2 + 1)) {
            if (!this.prefixes[s2].equals(string)) continue;
            return s2;
        }
        return -1;
    }

    public String suggestPrefixForURI(String string) {
        short s2 = this.getCodeForURI(string);
        if (s2 == -1) {
            return null;
        }
        if (this.prefixesForUri[s2].length >= 1) {
            return this.prefixesForUri[s2][0];
        }
        return null;
    }

    public String getPrefixWithIndex(short s2, int n2) {
        if (n2 == 0) {
            return "";
        }
        return this.prefixesForUri[s2][n2 - 1];
    }

    public synchronized int allocate(String string, String string2, String string3) {
        short s2;
        if ((NamespaceConstant.isReserved(string2) || string2.equals("http://saxon.sf.net/")) && (s2 = StandardNames.getFingerprint(string2, string3)) != -1) {
            int n2;
            short s3 = StandardNames.getURICode(s2);
            if (string.equals("")) {
                n2 = 0;
            } else {
                String[] stringArray = this.prefixesForUri[s3];
                int n3 = Arrays.asList(stringArray).indexOf(string);
                if (n3 < 0) {
                    if (stringArray.length == 1023) {
                        throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                    }
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    this.prefixesForUri[s3] = stringArray2;
                    n3 = stringArray.length;
                }
                n2 = n3 + 1;
            }
            return (n2 << 20) + s2;
        }
        s2 = this.allocateCodeForURI(string2);
        return this.allocateInternal(string, s2, string3);
    }

    public synchronized int allocate(String string, short s2, String string2) {
        if (NamespaceConstant.isSpecialURICode(s2)) {
            return this.allocate(string, this.getURIFromURICode(s2), string2);
        }
        return this.allocateInternal(string, s2, string2);
    }

    private int allocateInternal(String string, short s2, String string2) {
        int n2;
        int n3 = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n4 = 1;
        String[] stringArray = this.prefixesForUri[s2];
        if (string.equals("")) {
            n2 = 0;
        } else {
            int n5 = Arrays.asList(stringArray).indexOf(string);
            if (n5 < 0) {
                if (stringArray.length == 1023) {
                    throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                }
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string;
                this.prefixesForUri[s2] = stringArray2;
                n5 = stringArray.length;
            }
            n2 = n5 + 1;
        }
        if (this.hashslots[n3] == null) {
            NameEntry nameEntry;
            this.hashslots[n3] = nameEntry = new NameEntry(s2, string2);
        } else {
            NameEntry nameEntry = this.hashslots[n3];
            while (true) {
                boolean bl;
                boolean bl2 = nameEntry.localName.equals(string2);
                boolean bl3 = bl = nameEntry.uriCode == s2;
                if (bl2 && bl) break;
                NameEntry nameEntry2 = nameEntry.nextEntry;
                if (++n4 >= 1024) {
                    throw new NamePoolLimitException("Saxon name pool is full");
                }
                if (nameEntry2 == null) {
                    NameEntry nameEntry3;
                    nameEntry.nextEntry = nameEntry3 = new NameEntry(s2, string2);
                    break;
                }
                nameEntry = nameEntry2;
            }
        }
        return (n2 << 20) + (n4 << 10) + n3;
    }

    public synchronized int allocateNamespaceCode(int n2) {
        short s2;
        int n3 = n2 & 0xFFFFF;
        if ((n3 & 0xFFC00) == 0) {
            s2 = StandardNames.getURICode(n3);
        } else {
            NameEntry nameEntry = this.getNameEntry(n2);
            if (nameEntry == null) {
                this.unknownNameCode(n2);
                return -1;
            }
            s2 = nameEntry.uriCode;
        }
        int n4 = NamePool.getPrefixIndex(n2);
        String string = this.getPrefixWithIndex(s2, n4);
        short s3 = this.allocateCodeForPrefix(string);
        return (s3 << 16) + s2;
    }

    public String getURI(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            return StandardNames.getURI(n2 & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n2);
        if (nameEntry == null) {
            this.unknownNameCode(n2);
            return null;
        }
        return this.uris[nameEntry.uriCode];
    }

    public short getURICode(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            return StandardNames.getURICode(n2 & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n2);
        if (nameEntry == null) {
            this.unknownNameCode(n2);
            return -1;
        }
        return nameEntry.uriCode;
    }

    public String getLocalName(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            return StandardNames.getLocalName(n2 & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n2);
        if (nameEntry == null) {
            this.unknownNameCode(n2);
            return null;
        }
        return nameEntry.localName;
    }

    public String getPrefix(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            return StandardNames.getPrefix(n2 & 0xFFFFF);
        }
        short s2 = this.getURICode(n2);
        int n3 = NamePool.getPrefixIndex(n2);
        return this.getPrefixWithIndex(s2, n3);
    }

    public String getDisplayName(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            int n3 = NamePool.getPrefixIndex(n2);
            short s2 = this.getURICode(n2);
            String string = this.getPrefixWithIndex(s2, n3);
            if (string.equals("")) {
                return StandardNames.getLocalName(n2 & 0xFFFFF);
            }
            return string + ':' + StandardNames.getLocalName(n2 & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n2);
        if (nameEntry == null) {
            this.unknownNameCode(n2);
            return null;
        }
        int n4 = NamePool.getPrefixIndex(n2);
        String string = this.getPrefixWithIndex(nameEntry.uriCode, n4);
        if (string == null || string.equals("")) {
            return nameEntry.localName;
        }
        return string + ':' + nameEntry.localName;
    }

    public String getClarkName(int n2) {
        if ((n2 & 0xFFC00) == 0) {
            return StandardNames.getClarkName(n2 & 0xFFFFF);
        }
        NameEntry nameEntry = this.getNameEntry(n2);
        if (nameEntry == null) {
            this.unknownNameCode(n2);
            return null;
        }
        if (nameEntry.uriCode == 0) {
            return nameEntry.localName;
        }
        String string = '{' + this.getURIFromURICode(nameEntry.uriCode) + '}' + nameEntry.localName;
        return string.intern();
    }

    public int allocateClarkName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string3 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string2 = string.substring(n2 + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    public static String[] parseClarkName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string3 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string2 = string.substring(n2 + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        String[] stringArray = new String[]{string3, string2};
        return stringArray;
    }

    private void unknownNameCode(int n2) {
        throw new IllegalArgumentException("Unknown name code " + n2);
    }

    public int getFingerprint(String string, String string2) {
        short s2;
        short s3;
        if (string.equals("")) {
            s3 = 0;
        } else {
            if ((NamespaceConstant.isReserved(string) || string.equals("http://saxon.sf.net/")) && (s2 = StandardNames.getFingerprint(string, string2)) != -1) {
                return s2;
            }
            s3 = -1;
            for (s2 = 0; s2 < this.urisUsed; s2 = (short)(s2 + 1)) {
                if (!this.uris[s2].equals(string)) continue;
                s3 = s2;
                break;
            }
            if (s3 == -1) {
                return -1;
            }
        }
        s2 = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n2 = 1;
        if (this.hashslots[s2] == null) {
            return -1;
        }
        NameEntry nameEntry = this.hashslots[s2];
        while (nameEntry.uriCode != s3 || !nameEntry.localName.equals(string2)) {
            NameEntry nameEntry2 = nameEntry.nextEntry;
            ++n2;
            if (nameEntry2 == null) {
                return -1;
            }
            nameEntry = nameEntry2;
        }
        return (n2 << 10) + s2;
    }

    public String getURIFromNamespaceCode(int n2) {
        return this.uris[n2 & 0xFFFF];
    }

    public String getURIFromURICode(short s2) {
        return this.uris[s2];
    }

    public String getPrefixFromNamespaceCode(int n2) {
        return this.prefixes[n2 >> 16];
    }

    public int allocateLexicalQName(CharSequence charSequence, boolean bl, NamespaceResolver namespaceResolver, NameChecker nameChecker) throws DynamicError {
        try {
            String[] stringArray = nameChecker.getQNameParts(charSequence);
            String string = namespaceResolver.getURIForPrefix(stringArray[0], bl);
            if (string == null) {
                throw new DynamicError("Namespace prefix '" + stringArray[0] + "' has not been declared");
            }
            return this.allocate(stringArray[0], string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            throw new DynamicError(qNameException.getMessage());
        }
    }

    public int getFingerprintForExpandedName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n2 + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    public void setClientData(Class clazz, Object object) {
        if (this.clientData == null) {
            this.clientData = new HashMap(10);
        }
        this.clientData.put(clazz, object);
    }

    public Object getClientData(Class clazz) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(clazz);
    }

    public synchronized void diagnosticDump() {
        int n2;
        System.err.println("Contents of NamePool " + this);
        for (n2 = 0; n2 < 1024; ++n2) {
            NameEntry nameEntry = this.hashslots[n2];
            int n3 = 0;
            while (nameEntry != null) {
                System.err.println("Fingerprint " + n3 + '/' + n2);
                System.err.println("  local name = " + nameEntry.localName + " uri code = " + nameEntry.uriCode);
                nameEntry = nameEntry.nextEntry;
                ++n3;
            }
        }
        for (n2 = 0; n2 < this.prefixesUsed; ++n2) {
            System.err.println("Prefix " + n2 + " = " + this.prefixes[n2]);
        }
        for (n2 = 0; n2 < this.urisUsed; ++n2) {
            System.err.println("URI " + n2 + " = " + this.uris[n2]);
            System.err.println("Prefixes for URI " + n2 + " = " + this.prefixesForUri[n2]);
        }
    }

    public synchronized void statistics() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 1024; ++i2) {
            NameEntry nameEntry = this.hashslots[i2];
            if (nameEntry != null) {
                ++n2;
            }
            while (nameEntry != null) {
                nameEntry = nameEntry.nextEntry;
                ++n3;
            }
        }
        System.err.println("NamePool contents: " + n3 + " entries in " + n2 + " chains. " + this.prefixesUsed + " prefixes, " + this.urisUsed + " URIs");
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String string) {
            super(string);
        }
    }

    private static class NameEntry
    implements Serializable {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short s2, String string) {
            this.uriCode = s2;
            this.localName = string.intern();
            this.nextEntry = null;
        }
    }
}

