/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Err;
import net.sf.saxon.om.QNameException;

public abstract class NameChecker {
    public final boolean isQName(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return this.isValidNCName(string);
        }
        if (n2 == 0 || n2 == string.length() - 1) {
            return false;
        }
        if (!this.isValidNCName(string.substring(0, n2))) {
            return false;
        }
        return this.isValidNCName(string.substring(n2 + 1));
    }

    public abstract boolean isValidNCName(String var1);

    public static final String getPrefix(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public final String[] getQNameParts(CharSequence charSequence) throws QNameException {
        String[] stringArray = new String[2];
        int n2 = -1;
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (charSequence.charAt(i2) != ':') continue;
            n2 = i2;
            break;
        }
        if (n2 < 0) {
            stringArray[0] = "";
            stringArray[1] = ((Object)charSequence).toString();
            if (!this.isValidNCName(stringArray[1])) {
                throw new QNameException("Invalid QName " + Err.wrap(charSequence));
            }
        } else {
            if (n2 == 0) {
                throw new QNameException("QName cannot start with colon: " + Err.wrap(charSequence));
            }
            if (n2 == n3 - 1) {
                throw new QNameException("QName cannot end with colon: " + Err.wrap(charSequence));
            }
            stringArray[0] = ((Object)charSequence.subSequence(0, n2)).toString();
            stringArray[1] = ((Object)charSequence.subSequence(n2 + 1, n3)).toString();
            if (!this.isValidNCName(stringArray[1])) {
                throw new QNameException("Invalid QName local part " + Err.wrap(stringArray[1]));
            }
        }
        return stringArray;
    }

    public abstract boolean isValidChar(int var1);

    public abstract String getXMLVersion();
}

