/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;

public class NumberFormatter
implements Serializable {
    public static boolean methodInitialized = false;
    public static Method isLetterOrDigitMethod = null;
    private static int[] nonBmpZeroDigits = new int[]{66720, 67534, 67544, 67554, 67564, 67574};
    private ArrayList formatTokens;
    private ArrayList punctuationTokens;
    private boolean startsWithPunctuation;
    static /* synthetic */ Class class$java$lang$Character;

    public void prepare(String string) {
        if (string.length() == 0) {
            string = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        int n2 = string.length();
        int n3 = 0;
        boolean bl = true;
        this.startsWithPunctuation = true;
        while (n3 < n2) {
            String string2;
            int n4 = string.charAt(n3);
            int n5 = n3++;
            if (XMLChar.isHighSurrogate(n4)) {
                n4 = XMLChar.supplemental((char)n4, string.charAt(n3));
            }
            while (NumberFormatter.isLetterOrDigit(n4) && ++n3 != n2) {
                n4 = string.charAt(n3);
                if (!XMLChar.isHighSurrogate(n4)) continue;
                n4 = XMLChar.supplemental((char)n4, string.charAt(++n3));
            }
            if (n3 > n5) {
                string2 = string.substring(n5, n3);
                this.formatTokens.add(string2);
                if (bl) {
                    this.punctuationTokens.add(".");
                    this.startsWithPunctuation = false;
                    bl = false;
                }
            }
            if (n3 == n2) break;
            n5 = n3;
            n4 = string.charAt(n3);
            if (XMLChar.isHighSurrogate(n4)) {
                n4 = XMLChar.supplemental((char)n4, string.charAt(++n3));
            }
            while (!NumberFormatter.isLetterOrDigit(n4)) {
                bl = false;
                if (++n3 == n2) break;
                n4 = string.charAt(n3);
                if (!XMLChar.isHighSurrogate(n4)) continue;
                n4 = XMLChar.supplemental((char)n4, string.charAt(++n3));
            }
            if (n3 <= n5) continue;
            string2 = string.substring(n5, n3);
            this.punctuationTokens.add(string2);
        }
        if (this.formatTokens.size() == 0) {
            this.formatTokens.add("1");
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    private static boolean isLetterOrDigit(int n2) {
        Object[] objectArray;
        if (n2 <= 65535) {
            return Character.isLetterOrDigit((char)n2);
        }
        if (!methodInitialized) {
            try {
                objectArray = new Class[]{Integer.TYPE};
                isLetterOrDigitMethod = (class$java$lang$Character == null ? (class$java$lang$Character = NumberFormatter.class$("java.lang.Character")) : class$java$lang$Character).getDeclaredMethod("isLetterOrDigit", (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (isLetterOrDigitMethod != null) {
            try {
                objectArray = new Object[]{new Integer(n2)};
                Boolean bl = (Boolean)isLetterOrDigitMethod.invoke(null, objectArray);
                return bl;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
        }
        return NumberFormatter.getDigitValue(n2) != -1;
    }

    public static int getDigitValue(int n2) {
        if (n2 <= 65535) {
            if (Character.isDigit((char)n2)) {
                return Character.getNumericValue((char)n2);
            }
            return -1;
        }
        for (int i2 = 0; i2 < nonBmpZeroDigits.length; ++i2) {
            if (n2 < nonBmpZeroDigits[i2] || n2 > nonBmpZeroDigits[i2] + 9) continue;
            return n2 - nonBmpZeroDigits[i2];
        }
        return -1;
    }

    public CharSequence format(List list, int n2, String string, String string2, String string3, Numberer numberer) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        int n3 = 0;
        int n4 = 0;
        if (this.startsWithPunctuation) {
            fastStringBuffer.append((String)this.punctuationTokens.get(n4));
        }
        while (n3 < list.size()) {
            String string4;
            Object e2;
            if (n3 > 0) {
                if (n4 == 0 && this.startsWithPunctuation) {
                    fastStringBuffer.append(".");
                } else {
                    fastStringBuffer.append((String)this.punctuationTokens.get(n4));
                }
            }
            if ((e2 = list.get(n3++)) instanceof Long) {
                long l2 = (Long)e2;
                string4 = numberer.format(l2, (String)this.formatTokens.get(n4), n2, string, string2, string3);
            } else {
                string4 = e2.toString();
            }
            fastStringBuffer.append(string4);
            if (++n4 != this.formatTokens.size()) continue;
            --n4;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            fastStringBuffer.append((String)this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return fastStringBuffer.condense();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

