/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jdom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object object, NodeWrapper nodeWrapper, int n2) {
        this.node = object;
        this.parent = nodeWrapper;
        this.index = n2;
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper) {
        return this.makeWrapper(object, documentWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n2) {
        NodeWrapper nodeWrapper2;
        if (object instanceof Document) {
            return documentWrapper;
        }
        if (object instanceof Element) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n2);
            nodeWrapper2.nodeKind = 1;
        } else if (object instanceof Attribute) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n2);
            nodeWrapper2.nodeKind = (short)2;
        } else if (object instanceof String || object instanceof Text) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n2);
            nodeWrapper2.nodeKind = (short)3;
        } else if (object instanceof Comment) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n2);
            nodeWrapper2.nodeKind = (short)8;
        } else if (object instanceof ProcessingInstruction) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n2);
            nodeWrapper2.nodeKind = (short)7;
        } else {
            if (object instanceof Namespace) {
                throw new IllegalArgumentException("Cannot wrap JDOM namespace objects");
            }
            throw new IllegalArgumentException("Bad node type in JDOM! " + object.getClass() + " instance " + object.toString());
        }
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    public Object getUnderlyingNode() {
        if (this.node instanceof List) {
            return ((List)this.node).get(0);
        }
        return this.node;
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((AtomicValue)this.atomize());
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 642;
        }
        return 641;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        return this.node.equals(nodeWrapper.node);
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo nodeInfo = this;
        if (this.getNodeKind() != 1) {
            nodeInfo = this.getParent();
        }
        while (nodeInfo != null) {
            String string = nodeInfo.getAttributeValue(385);
            if (string != null) {
                return string;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof SiblingCountingNode) {
            return Navigator.compareOrder(this, (SiblingCountingNode)nodeInfo);
        }
        return -nodeInfo.compareOrder(this);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.node instanceof List) {
            List list = (List)this.node;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Text text = (Text)list.get(i2);
                fastStringBuffer.append(NodeWrapper.getStringValue(text));
            }
            return fastStringBuffer;
        }
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object object) {
        if (object instanceof Document) {
            List list = ((Document)object).getContent();
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            NodeWrapper.expandStringValue(list, fastStringBuffer);
            return fastStringBuffer.toString();
        }
        if (object instanceof Element) {
            return ((Element)object).getValue();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getValue();
        }
        if (object instanceof Text) {
            return ((Text)object).getText();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Comment) {
            return ((Comment)object).getText();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getData();
        }
        if (object instanceof Namespace) {
            return ((Namespace)object).getURI();
        }
        return "";
    }

    private static void expandStringValue(List list, FastStringBuffer fastStringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof Element) {
                fastStringBuffer.append(((Element)e2).getValue());
                continue;
            }
            if (e2 instanceof Text) {
                fastStringBuffer.append(((Text)e2).getText());
                continue;
            }
            if (e2 instanceof EntityRef) {
                throw new IllegalStateException("Unexpanded entity in JDOM tree");
            }
            if (!(e2 instanceof DocType)) {
                throw new AssertionError((Object)"Unknown JDOM node type");
            }
        }
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
                }
                throw new IllegalStateException("Unknown JDOM node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator;
            int n2 = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    axisIterator = this.parent.iterateAxis((byte)3);
                    break;
                }
                case 2: {
                    axisIterator = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    axisIterator = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.isSameNodeInfo(this)) {
                    this.index = n2;
                    return this.index;
                }
                if (((NodeWrapper)nodeInfo).node instanceof List) {
                    n2 += ((List)((NodeWrapper)nodeInfo).node).size();
                    continue;
                }
                ++n2;
            }
            throw new IllegalStateException("JDOM node not linked to parent node");
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceIterator(this, nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton(this.parent, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n2) {
        if (this.nodeKind == 1) {
            NamePool namePool = this.docWrapper.getNamePool();
            String string = namePool.getURI(n2);
            String string2 = namePool.getLocalName(n2);
            return ((Element)this.node).getAttributeValue(string2, string.equals("http://www.w3.org/XML/1998/namespace") ? Namespace.XML_NAMESPACE : Namespace.getNamespace(string));
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey(this, fastStringBuffer, true);
    }

    public int getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
        Navigator.copy(this, receiver, this.docWrapper.getNamePool(), n2, bl, n3);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        Navigator.sendNamespaceDeclarations(this, receiver, bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            List list = element.getAdditionalNamespaces();
            int n2 = list.size() + 1;
            int[] nArray2 = n2 <= nArray.length ? nArray : new int[n2];
            NamePool namePool = this.getNamePool();
            Namespace namespace = element.getNamespace();
            String string = namespace.getPrefix();
            String string2 = namespace.getURI();
            nArray2[0] = namePool.allocateNamespaceCode(string, string2);
            int n3 = 1;
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    namespace = (Namespace)iterator.next();
                    nArray2[n3++] = namePool.allocateNamespaceCode(namespace.getPrefix(), namespace.getURI());
                }
            }
            if (n2 < nArray.length) {
                nArray2[n2] = -1;
            }
            return nArray2;
        }
        return null;
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (bl) {
                if (!bl2) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = nodeWrapper2.getSiblingPosition();
                Object var5_5 = null;
                if (bl2) {
                    int n2;
                    for (n2 = 0; n2 <= this.ix; ++n2) {
                        var5_5 = this.children.next();
                    }
                    if (var5_5 instanceof Text) {
                        n2 = 0;
                        while (var5_5 instanceof Text) {
                            if (this.children.hasNext()) {
                                var5_5 = this.children.next();
                                ++this.ix;
                                continue;
                            }
                            n2 = 1;
                            break;
                        }
                        if (n2 == 0) {
                            this.children.previous();
                        }
                    } else {
                        ++this.ix;
                    }
                } else {
                    for (int i2 = 0; i2 < this.ix; ++i2) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object e2 = this.children.next();
                    if (e2 instanceof DocType) {
                        this.advance();
                        return;
                    }
                    if (e2 instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    if (e2 instanceof Text) {
                        if (this.isAtomizing()) {
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
                            fastStringBuffer.append(NodeWrapper.getStringValue(NodeWrapper.this.node));
                            while (this.children.hasNext()) {
                                Object e3 = this.children.next();
                                if (e3 instanceof Text) {
                                    fastStringBuffer.append(NodeWrapper.getStringValue(e3));
                                    ++this.ix;
                                    continue;
                                }
                                this.children.previous();
                                break;
                            }
                            this.current = new UntypedAtomicValue(fastStringBuffer);
                        } else {
                            this.current = NodeWrapper.this.makeWrapper(e2, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                            ArrayList<Object> arrayList = null;
                            while (this.children.hasNext()) {
                                Object e4 = this.children.next();
                                if (e4 instanceof Text) {
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<Object>(4);
                                        arrayList.add(((NodeWrapper)this.current).node);
                                    }
                                    arrayList.add(e4);
                                    ++this.ix;
                                    continue;
                                }
                                this.children.previous();
                                break;
                            }
                            if (arrayList != null) {
                                ((NodeWrapper)this.current).node = arrayList;
                            }
                        }
                    } else {
                        this.current = this.isAtomizing() ? new UntypedAtomicValue(NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e2, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                    }
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object e5 = this.children.previous();
                if (e5 instanceof DocType) {
                    this.advance();
                    return;
                }
                if (e5 instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                if (e5 instanceof Text) {
                    if (this.isAtomizing()) {
                        StringBuffer stringBuffer = new StringBuffer(100);
                        stringBuffer.insert(0, NodeWrapper.getStringValue(e5));
                        while (this.children.hasPrevious()) {
                            Object e6 = this.children.previous();
                            if (e6 instanceof Text) {
                                stringBuffer.insert(0, NodeWrapper.getStringValue(e6));
                                --this.ix;
                                continue;
                            }
                            this.children.next();
                            break;
                        }
                        this.current = new UntypedAtomicValue(stringBuffer);
                    } else {
                        this.current = NodeWrapper.this.makeWrapper(e5, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                        ArrayList<Object> arrayList = null;
                        while (this.children.hasPrevious()) {
                            Object e7 = this.children.previous();
                            if (e7 instanceof Text) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Object>(4);
                                    arrayList.add(((NodeWrapper)this.current).node);
                                }
                                arrayList.add(0, e7);
                                --this.ix;
                                continue;
                            }
                            this.children.next();
                            break;
                        }
                        if (arrayList != null) {
                            ((NodeWrapper)this.current).node = arrayList;
                        }
                    }
                } else {
                    this.current = this.isAtomizing() ? new UntypedAtomicValue(NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e5, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.atts = ((Element)nodeWrapper2.node).getAttributes().iterator();
        }

        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

