/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class While
extends Instruction {
    private Expression test;
    private Expression action;

    public While(Expression expression, Expression expression2) {
        this.test = expression;
        this.action = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public int getInstructionNameCode() {
        return 265;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.test = this.test.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.test = this.test.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.test);
        this.action = this.action.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.test = this.test.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.test);
        this.action = this.action.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.test = this.doPromotion(this.test, promotionOffer);
        this.action = this.doPromotion(this.action, promotionOffer);
    }

    public final boolean createsNewNodes() {
        int n2 = this.action.getSpecialProperties();
        return (n2 & 0x400000) == 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.test, this.action);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        while (this.test.effectiveBooleanValue(xPathContext)) {
            this.action.process(xPathContext);
        }
        return null;
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "while");
        this.test.display(n2 + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n2) + "do");
        this.action.display(n2 + 1, printStream, configuration);
    }
}

