/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 138;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        String string = ((Object)this.expandChildren(xPathContext)).toString();
        string = this.checkContent(string, xPathContext);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.comment(string, this.locationId, 0);
        return null;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        int n2;
        while ((n2 = string.indexOf("--")) >= 0) {
            if (this.isXSLT()) {
                string = string.substring(0, n2 + 1) + ' ' + string.substring(n2 + 1);
                continue;
            }
            DynamicError dynamicError = new DynamicError("Invalid characters (--) in comment", this);
            dynamicError.setErrorCode("XQDY0072");
            dynamicError.setXPathContext(xPathContext);
            throw DynamicError.makeDynamicError(Comment.dynamicError(this, dynamicError, xPathContext));
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            if (this.isXSLT()) {
                string = string + ' ';
            } else {
                DynamicError dynamicError = new DynamicError("Comment cannot end in '-'", this);
                dynamicError.setErrorCode("XQDY0072");
                dynamicError.setXPathContext(xPathContext);
                throw DynamicError.makeDynamicError(Comment.dynamicError(this, dynamicError, xPathContext));
            }
        }
        return string;
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "comment");
        super.display(n2 + 1, printStream, configuration);
    }
}

