/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class VendorFunctionLibrary
implements FunctionLibrary {
    private HashMap functionTable;
    static /* synthetic */ Class class$net$sf$saxon$functions$Evaluate;
    static /* synthetic */ Class class$net$sf$saxon$functions$Parse;
    static /* synthetic */ Class class$net$sf$saxon$functions$Serialize;

    public VendorFunctionLibrary() {
        this.init();
    }

    protected StandardFunction.Entry register(String string, Class clazz, int n2, int n3, int n4, ItemType itemType, int n5) {
        StandardFunction.Entry entry = StandardFunction.makeEntry(string, clazz, n2, n3, n4, itemType, n5);
        this.functionTable.put(string, entry);
        return entry;
    }

    protected void init() {
        this.functionTable = new HashMap(30);
        StandardFunction.Entry entry = this.register("evaluate", class$net$sf$saxon$functions$Evaluate == null ? (class$net$sf$saxon$functions$Evaluate = VendorFunctionLibrary.class$("net.sf.saxon.functions.Evaluate")) : class$net$sf$saxon$functions$Evaluate, 0, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("evaluate-node", class$net$sf$saxon$functions$Evaluate == null ? (class$net$sf$saxon$functions$Evaluate = VendorFunctionLibrary.class$("net.sf.saxon.functions.Evaluate")) : class$net$sf$saxon$functions$Evaluate, 3, 1, 1, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 16384);
        entry = this.register("eval", class$net$sf$saxon$functions$Evaluate == null ? (class$net$sf$saxon$functions$Evaluate = VendorFunctionLibrary.class$("net.sf.saxon.functions.Evaluate")) : class$net$sf$saxon$functions$Evaluate, 2, 1, 10, Type.ITEM_TYPE, 57344);
        StandardFunction.arg(entry, 0, Type.ANY_ATOMIC_TYPE, 16384);
        entry = this.register("expression", class$net$sf$saxon$functions$Evaluate == null ? (class$net$sf$saxon$functions$Evaluate = VendorFunctionLibrary.class$("net.sf.saxon.functions.Evaluate")) : class$net$sf$saxon$functions$Evaluate, 1, 1, 1, Type.ANY_ATOMIC_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("parse", class$net$sf$saxon$functions$Parse == null ? (class$net$sf$saxon$functions$Parse = VendorFunctionLibrary.class$("net.sf.saxon.functions.Parse")) : class$net$sf$saxon$functions$Parse, 0, 1, 1, NodeKindTest.DOCUMENT, 16384);
        StandardFunction.arg(entry, 0, Type.STRING_TYPE, 16384);
        entry = this.register("serialize", class$net$sf$saxon$functions$Serialize == null ? (class$net$sf$saxon$functions$Serialize = VendorFunctionLibrary.class$("net.sf.saxon.functions.Serialize")) : class$net$sf$saxon$functions$Serialize, 0, 2, 2, Type.STRING_TYPE, 16384);
        StandardFunction.arg(entry, 0, Type.NODE_TYPE, 24576);
        StandardFunction.arg(entry, 1, Type.STRING_TYPE, 16384);
    }

    public boolean isAvailable(int n2, String string, String string2, int n3) {
        if (string.equals("http://saxon.sf.net/")) {
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(string2);
            if (entry == null) {
                return false;
            }
            return n3 == -1 || n3 >= entry.minArguments && n3 <= entry.maxArguments;
        }
        return false;
    }

    public Expression bind(int n2, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (string.equals("http://saxon.sf.net/")) {
            SystemFunction systemFunction;
            StandardFunction.Entry entry = (StandardFunction.Entry)this.functionTable.get(string2);
            if (entry == null) {
                return null;
            }
            Class clazz = entry.implementationClass;
            try {
                systemFunction = (SystemFunction)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Failed to load Saxon extension function: " + exception.getMessage()));
            }
            systemFunction.setDetails(entry);
            systemFunction.setFunctionNameCode(n2);
            systemFunction.setArguments(expressionArray);
            this.checkArgumentCount(expressionArray.length, entry.minArguments, entry.maxArguments, string2);
            return systemFunction;
        }
        return null;
    }

    public Expression makeSaxonFunction(String string, StaticContext staticContext, Expression[] expressionArray) throws XPathException {
        String string2 = "http://saxon.sf.net/";
        int n2 = staticContext.getNamePool().allocate("saxon", string2, string);
        return this.bind(n2, string2, string, expressionArray);
    }

    private int checkArgumentCount(int n2, int n3, int n4, String string) throws XPathException {
        if (n3 == n4 && n2 != n3) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have " + n3 + VendorFunctionLibrary.pluralArguments(n3));
        }
        if (n2 < n3) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have at least " + n3 + VendorFunctionLibrary.pluralArguments(n3));
        }
        if (n2 > n4) {
            throw new StaticError("Function " + Err.wrap("saxon:" + string, 3) + " must have no more than " + n4 + VendorFunctionLibrary.pluralArguments(n4));
        }
        return n2;
    }

    public static String pluralArguments(int n2) {
        if (n2 == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

