/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue2.getPrimitiveValue();
        if (this.argument.length == 2) {
            return StringValue.makeStringValue(Substring.substring(charSequence, numericValue));
        }
        AtomicValue atomicValue3 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        NumericValue numericValue2 = (NumericValue)atomicValue3.getPrimitiveValue();
        return StringValue.makeStringValue(Substring.substring(charSequence, numericValue, numericValue2, xPathContext));
    }

    private static CharSequence substring(CharSequence charSequence, NumericValue numericValue) {
        long l2;
        int n2 = charSequence.length();
        if (numericValue instanceof IntegerValue) {
            l2 = ((IntegerValue)numericValue).longValue();
        } else {
            NumericValue numericValue2 = numericValue.round();
            if (numericValue2.compareTo(IntegerValue.ZERO) <= 0) {
                return charSequence;
            }
            if (numericValue2.compareTo(new IntegerValue(n2)) > 0) {
                return "";
            }
            try {
                l2 = numericValue2.longValue();
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"string length out of permissible range");
            }
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            char c2;
            if ((long)n3 >= l2) {
                return charSequence.subSequence(n4, charSequence.length());
            }
            if ((c2 = charSequence.charAt(n4++)) >= '\ud800' && c2 <= '\udbff') continue;
            ++n3;
        }
        return "";
    }

    private static CharSequence substring(CharSequence charSequence, NumericValue numericValue, NumericValue numericValue2, XPathContext xPathContext) {
        long l2;
        NumericValue numericValue3;
        long l3;
        int n2 = charSequence.length();
        if (numericValue instanceof IntegerValue) {
            l3 = ((IntegerValue)numericValue).longValue();
        } else if ((numericValue = numericValue.round()).compareTo(IntegerValue.ZERO) <= 0) {
            l3 = 0L;
        } else {
            if (numericValue.compareTo(new IntegerValue(n2)) > 0) {
                return "";
            }
            if (numericValue.isNaN()) {
                return "";
            }
            try {
                l3 = numericValue.longValue();
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"string length out of permissible range");
            }
        }
        try {
            numericValue3 = numericValue.arithmetic(15, numericValue2.round(), xPathContext);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)"Unexpected arithmetic failure in substring");
        }
        if (numericValue3 instanceof IntegerValue) {
            l2 = ((IntegerValue)numericValue3).longValue();
        } else {
            if (numericValue3.compareTo(IntegerValue.ZERO) <= 0) {
                return "";
            }
            if (numericValue3.isNaN()) {
                return "";
            }
            if (numericValue3.compareTo(new IntegerValue(n2)) > 0) {
                l2 = n2 + 1;
            } else {
                try {
                    l2 = numericValue3.ceiling().longValue();
                }
                catch (XPathException xPathException) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        while (n6 < n2) {
            char c2;
            if ((long)n5 >= l3) {
                if ((long)n5 < l2) {
                    if (n3 < 0) {
                        n3 = n6;
                    }
                } else {
                    n4 = n6;
                    break;
                }
            }
            if ((c2 = charSequence.charAt(n6++)) >= '\ud800' && c2 <= '\udbff') continue;
            ++n5;
        }
        if (n3 < 0 || n3 == n4) {
            return "";
        }
        if (n4 < 0) {
            return charSequence.subSequence(n3, charSequence.length());
        }
        return charSequence.subSequence(n3, n4);
    }
}

