/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class Remove
extends SystemFunction {
    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = super.simplify(staticContext);
        if (expression instanceof Remove) {
            return ((Remove)expression).simplifyAsTailExpression();
        }
        return expression;
    }

    private Expression simplifyAsTailExpression() {
        if (this.argument[1] instanceof IntegerValue && ((IntegerValue)this.argument[1]).longValue() == 1L) {
            TailExpression tailExpression = new TailExpression(this.argument[0], 2);
            tailExpression.setLocationId(this.getLocationId());
            tailExpression.setParentExpression(this.getParentExpression());
            return tailExpression;
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.argument[0].getItemType(typeHierarchy);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        int n2 = (int)numericValue.longValue();
        if (n2 < 1) {
            return sequenceIterator;
        }
        return new RemoveIterator(sequenceIterator, n2);
    }

    private class RemoveIterator
    implements SequenceIterator,
    LastPositionFinder {
        SequenceIterator base;
        int removePosition;
        int position = 0;
        Item current = null;

        public RemoveIterator(SequenceIterator sequenceIterator, int n2) {
            this.base = sequenceIterator;
            this.removePosition = n2;
        }

        public Item next() throws XPathException {
            this.current = this.base.next();
            if (this.current != null && this.base.position() == this.removePosition) {
                this.current = this.base.next();
            }
            this.position = this.current == null ? -1 : ++this.position;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public int getLastPosition() throws XPathException {
            if (this.base instanceof LastPositionFinder) {
                int n2 = ((LastPositionFinder)this.base).getLastPosition();
                if (this.removePosition >= 1 && this.removePosition <= n2) {
                    return n2 - 1;
                }
                return n2;
            }
            throw new AssertionError((Object)"base of removeIterator is not a LastPositionFinder");
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RemoveIterator(this.base.getAnother(), this.removePosition);
        }

        public int getProperties() {
            return this.base.getProperties() & 2;
        }
    }
}

