/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class NormalizeUnicode
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        int n2;
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return StringValue.EMPTY_STRING;
        }
        boolean bl = true;
        CharSequence charSequence = stringValue.getStringValueCS();
        if (charSequence instanceof CompressedWhitespace) {
            return stringValue;
        }
        for (n2 = charSequence.length() - 1; n2 >= 0; --n2) {
            if (charSequence.charAt(n2) <= '\u007f') continue;
            bl = false;
            break;
        }
        if (bl) {
            return stringValue;
        }
        n2 = 2;
        if (this.argument.length == 2) {
            object = this.argument[1].evaluateAsString(xPathContext).trim();
            if (((String)object).equals("NFC")) {
                n2 = 2;
            } else if (((String)object).equals("NFD")) {
                n2 = 0;
            } else if (((String)object).equals("NFKC")) {
                n2 = 3;
            } else if (((String)object).equals("NFKD")) {
                n2 = 1;
            } else {
                if (((String)object).equals("")) {
                    return stringValue;
                }
                String string = "Normalization form " + (String)object + " is not supported";
                DynamicError dynamicError = new DynamicError(string);
                dynamicError.setErrorCode("FOCH0003");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
        }
        object = new Normalizer((byte)n2);
        CharSequence charSequence2 = ((Normalizer)object).normalize(stringValue.getStringValueCS());
        return StringValue.makeStringValue(charSequence2);
    }
}

