/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.SecondsDurationValue;

public class Adjust
extends SystemFunction {
    int implicitTimezone;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.implicitTimezone = staticContext.getConfiguration().getImplicitTimezone();
        return super.simplify(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
        int n2 = this.argument.length;
        if (n2 == 1) {
            return calendarValue.adjustTimezone(this.implicitTimezone);
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return calendarValue.removeTimezone();
        }
        SecondsDurationValue secondsDurationValue = (SecondsDurationValue)atomicValue2.getPrimitiveValue();
        long l2 = secondsDurationValue.getLengthInMicroseconds();
        if (l2 % 60000000L != 0L) {
            DynamicError dynamicError = new DynamicError("Timezone is not an integral number of minutes");
            dynamicError.setErrorCode("FODT0003");
            dynamicError.setLocator(this);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        int n3 = (int)(l2 / 60000000L);
        if (Math.abs(n3) > 840) {
            DynamicError dynamicError = new DynamicError("Timezone out of range (-14:00 to +14:00)");
            dynamicError.setErrorCode("FODT0003");
            dynamicError.setLocator(this);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        return calendarValue.adjustTimezone(n3);
    }
}

