/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Token;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.trans.StaticError;

public final class Tokenizer {
    private int state = 0;
    public static final int DEFAULT_STATE = 0;
    public static final int BARE_NAME_STATE = 1;
    public static final int SEQUENCE_TYPE_STATE = 2;
    public static final int OPERATOR_STATE = 3;
    public int startLineNumber;
    public int currentToken = 0;
    public String currentTokenValue = null;
    public int currentTokenStartOffset = 0;
    private int nextToken = 0;
    private String nextTokenValue = null;
    private int nextTokenStartOffset = 0;
    public String input;
    public int inputOffset = 0;
    private int inputLength;
    private int lineNumber = 1;
    private int nextLineNumber = 1;
    private List newlineOffsets = null;
    private int precedingToken = -1;

    public int getState() {
        return this.state;
    }

    public void setState(int n2) {
        this.state = n2;
        if (n2 == 0) {
            this.precedingToken = -1;
            this.currentToken = -1;
        } else if (n2 == 3) {
            this.precedingToken = 104;
            this.currentToken = 104;
        }
    }

    public void tokenize(String string, int n2, int n3, int n4) throws StaticError {
        this.nextToken = 0;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = 0;
        this.inputOffset = n2;
        this.input = string;
        this.startLineNumber = n4;
        this.lineNumber = n4;
        this.nextLineNumber = n4;
        this.inputLength = n3 == -1 ? string.length() : n3;
        this.lookAhead();
        this.next();
    }

    public void next() throws StaticError {
        int n2;
        this.precedingToken = this.currentToken;
        this.currentToken = this.nextToken;
        this.currentTokenValue = this.nextTokenValue;
        if (this.currentTokenValue == null) {
            this.currentTokenValue = "";
        }
        this.currentTokenStartOffset = this.nextTokenStartOffset;
        this.lineNumber = this.nextLineNumber;
        switch (this.currentToken) {
            case 101: {
                n2 = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (n2 == -1 || this.followsOperator()) break;
                this.currentToken = n2;
                break;
            }
            case 12: {
                if (!this.followsOperator()) break;
                this.currentToken = 117;
                break;
            }
            case 107: {
                if (this.followsOperator()) break;
                this.currentToken = 17;
            }
        }
        if (this.currentToken == 117 || this.currentToken == 115) {
            return;
        }
        this.lookAhead();
        if (this.currentToken == 101) {
            if (this.state == 1) {
                return;
            }
            switch (this.nextToken) {
                case 5: {
                    n2 = Tokenizer.getBinaryOp(this.currentTokenValue);
                    if (n2 == -1) {
                        this.currentToken = Tokenizer.getFunctionType(this.currentTokenValue);
                        this.lookAhead();
                        break;
                    }
                    this.currentToken = n2;
                    break;
                }
                case 53: {
                    if (this.state == 2) break;
                    this.currentToken = 54;
                    this.lookAhead();
                    break;
                }
                case 39: {
                    this.lookAhead();
                    this.currentToken = 35;
                    break;
                }
                case 40: {
                    this.lookAhead();
                    this.currentToken = 108;
                    break;
                }
                case 21: {
                    if (this.currentTokenValue == "for") {
                        this.currentToken = 111;
                        break;
                    }
                    if (this.currentTokenValue == "some") {
                        this.currentToken = 31;
                        break;
                    }
                    if (this.currentTokenValue == "every") {
                        this.currentToken = 32;
                        break;
                    }
                    if (this.currentTokenValue != "let") break;
                    this.currentToken = 116;
                    break;
                }
                case 101: {
                    Object object;
                    String string;
                    int n3 = -1;
                    if (this.currentTokenValue.equals("element")) {
                        n3 = 55;
                    } else if (this.currentTokenValue.equals("attribute")) {
                        n3 = 56;
                    } else if (this.currentTokenValue.equals("processing-instruction")) {
                        n3 = 57;
                    }
                    if (n3 != -1) {
                        string = this.nextTokenValue;
                        object = this.currentTokenValue;
                        int n4 = this.inputOffset;
                        this.lookAhead();
                        if (this.nextToken == 53) {
                            this.currentToken = n3;
                            this.currentTokenValue = string;
                            this.lookAhead();
                            return;
                        }
                        this.currentToken = 101;
                        this.currentTokenValue = object;
                        this.inputOffset = n4;
                        this.nextToken = 101;
                        this.nextTokenValue = string;
                    }
                    if ((object = (Integer)Token.doubleKeywords.get(string = this.currentTokenValue + ' ' + this.nextTokenValue)) == null) break;
                    this.currentToken = (Integer)object;
                    this.currentTokenValue = string;
                    this.lookAhead();
                    return;
                }
            }
        }
    }

    public void treatCurrentAsOperator() {
        switch (this.currentToken) {
            case 101: {
                int n2 = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (n2 == -1) break;
                this.currentToken = n2;
                break;
            }
            case 107: {
                this.currentToken = 17;
            }
        }
    }

    public void lookAhead() throws StaticError {
        char c2;
        this.precedingToken = this.nextToken;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = this.inputOffset;
        block39: while (true) {
            if (this.inputOffset >= this.inputLength) {
                this.nextToken = 0;
                return;
            }
            c2 = this.input.charAt(this.inputOffset++);
            switch (c2) {
                case '/': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '/') {
                        ++this.inputOffset;
                        this.nextToken = 8;
                        return;
                    }
                    this.nextToken = 2;
                    return;
                }
                case ':': {
                    if (this.inputOffset < this.inputLength) {
                        if (this.input.charAt(this.inputOffset) == ':') {
                            ++this.inputOffset;
                            this.nextToken = 39;
                            return;
                        }
                        if (this.input.charAt(this.inputOffset) == '=') {
                            this.nextToken = 52;
                            ++this.inputOffset;
                            return;
                        }
                    }
                    throw new StaticError("Unexpected colon at start of token");
                }
                case '@': {
                    this.nextToken = 3;
                    return;
                }
                case '?': {
                    this.nextToken = 113;
                    return;
                }
                case '[': {
                    this.nextToken = 4;
                    return;
                }
                case ']': {
                    this.nextToken = 103;
                    return;
                }
                case '{': {
                    this.nextToken = 53;
                    return;
                }
                case '}': {
                    this.nextToken = 115;
                    return;
                }
                case ';': {
                    this.nextToken = 90;
                    this.state = 0;
                    return;
                }
                case '(': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '#') {
                        ++this.inputOffset;
                        int n2 = this.inputOffset;
                        int n3 = 1;
                        while (n3 > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == '#' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --n3;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == '#') {
                                ++n3;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (n3 > 0) {
                            throw new StaticError("Unclosed XQuery pragma");
                        }
                        this.nextToken = 118;
                        this.nextTokenValue = this.input.substring(n2, this.inputOffset - 2);
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':') {
                        ++this.inputOffset;
                        int n4 = 1;
                        while (n4 > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == ':' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --n4;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == ':') {
                                ++n4;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (n4 > 0) {
                            throw new StaticError("Unclosed XPath comment");
                        }
                        this.lookAhead();
                    } else {
                        this.nextToken = 5;
                    }
                    return;
                }
                case ')': {
                    this.nextToken = 104;
                    return;
                }
                case '+': {
                    this.nextToken = 15;
                    return;
                }
                case '-': {
                    this.nextToken = 16;
                    return;
                }
                case '=': {
                    this.nextToken = 6;
                    return;
                }
                case '!': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 22;
                        return;
                    }
                    throw new StaticError("'!' without '='");
                }
                case '*': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':') {
                        char c3;
                        ++this.inputOffset;
                        this.nextToken = 62;
                        if (this.inputOffset < this.inputLength && " \r\t\n".indexOf(c3 = this.input.charAt(this.inputOffset)) >= 0) {
                            throw new StaticError("Whitespace is not allowed after '*:'");
                        }
                        return;
                    }
                    this.nextToken = 107;
                    return;
                }
                case ',': {
                    this.nextToken = 7;
                    return;
                }
                case '$': {
                    this.nextToken = 21;
                    return;
                }
                case '|': {
                    this.nextToken = 1;
                    return;
                }
                case '<': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 14;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '<') {
                        ++this.inputOffset;
                        this.nextToken = 37;
                        return;
                    }
                    this.nextToken = 12;
                    return;
                }
                case '>': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 13;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '>') {
                        ++this.inputOffset;
                        this.nextToken = 38;
                        return;
                    }
                    this.nextToken = 11;
                    return;
                }
                case '.': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '.') {
                        ++this.inputOffset;
                        this.nextToken = 106;
                        return;
                    }
                    if (this.inputOffset == this.inputLength || this.input.charAt(this.inputOffset) < '0' || this.input.charAt(this.inputOffset) > '9') {
                        this.nextToken = 105;
                        return;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean bl = true;
                    boolean bl2 = false;
                    boolean bl3 = true;
                    boolean bl4 = false;
                    block42: while (!bl4) {
                        switch (c2) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                bl2 = false;
                                break;
                            }
                            case '.': {
                                if (bl3) {
                                    bl3 = false;
                                    bl2 = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            case 'E': 
                            case 'e': {
                                if (bl) {
                                    bl2 = true;
                                    bl = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            case '+': 
                            case '-': {
                                if (bl2) {
                                    bl2 = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            default: {
                                if ('a' <= c2 && c2 <= 'z' || c2 > '\u007f') {
                                    throw new StaticError("Separator needed after numeric literal");
                                }
                                --this.inputOffset;
                                break block42;
                            }
                        }
                        if (this.inputOffset >= this.inputLength) break;
                        c2 = this.input.charAt(this.inputOffset++);
                    }
                    this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                    this.nextToken = 109;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.nextTokenValue = "";
                    while (true) {
                        this.inputOffset = this.input.indexOf(c2, this.inputOffset);
                        if (this.inputOffset < 0) {
                            this.inputOffset = this.nextTokenStartOffset + 1;
                            throw new StaticError("Unmatched quote in expression");
                        }
                        this.nextTokenValue = this.nextTokenValue + this.input.substring(this.nextTokenStartOffset + 1, this.inputOffset++);
                        if (this.inputOffset >= this.inputLength || this.input.charAt(this.inputOffset) != c2) break;
                        this.nextTokenValue = this.nextTokenValue + c2;
                        this.nextTokenStartOffset = this.inputOffset++;
                    }
                    if (this.nextTokenValue.indexOf(10) >= 0) {
                        for (int i2 = 0; i2 < this.nextTokenValue.length(); ++i2) {
                            if (this.nextTokenValue.charAt(i2) != '\n') continue;
                            ++this.lineNumber;
                            if (this.newlineOffsets == null) {
                                this.newlineOffsets = new ArrayList(20);
                            }
                            this.newlineOffsets.add(new Integer(this.nextTokenStartOffset + i2));
                        }
                    }
                    this.nextTokenValue = this.nextTokenValue.intern();
                    this.nextToken = 102;
                    return;
                }
                case '\n': {
                    this.incrementLineNumber();
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.nextTokenStartOffset = this.inputOffset;
                    continue block39;
                }
                default: {
                    if (c2 >= '\u0080' || Character.isLetter(c2)) break block39;
                    throw new StaticError("Invalid character '" + c2 + "' in expression");
                }
                case '_': 
            }
            break;
        }
        block45: while (this.inputOffset < this.inputLength) {
            c2 = this.input.charAt(this.inputOffset);
            switch (c2) {
                case ':': {
                    if (this.inputOffset + 1 >= this.inputLength) break;
                    char c4 = this.input.charAt(this.inputOffset + 1);
                    if (c4 == ':') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                        this.nextToken = 35;
                        this.inputOffset += 2;
                        return;
                    }
                    if (c4 == '*') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                        this.nextToken = 108;
                        this.inputOffset += 2;
                        return;
                    }
                    if (c4 != '=') break;
                    this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                    this.nextToken = 101;
                    return;
                }
                case '-': 
                case '.': 
                case '_': {
                    break;
                }
                default: {
                    if (c2 < '\u0080' && !Character.isLetterOrDigit(c2)) break block45;
                }
            }
            ++this.inputOffset;
        }
        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
        this.nextToken = 101;
    }

    private static int getBinaryOp(String string) {
        switch (string.length()) {
            case 2: {
                if (string == "or") {
                    return 9;
                }
                if (string == "is") {
                    return 20;
                }
                if (string == "to") {
                    return 29;
                }
                if (string == "in") {
                    return 30;
                }
                if (string == "eq") {
                    return 44;
                }
                if (string == "ne") {
                    return 45;
                }
                if (string == "gt") {
                    return 46;
                }
                if (string == "ge") {
                    return 48;
                }
                if (string == "lt") {
                    return 47;
                }
                if (string != "le") break;
                return 49;
            }
            case 3: {
                if (string == "and") {
                    return 10;
                }
                if (string == "div") {
                    return 18;
                }
                if (string != "mod") break;
                return 19;
            }
            case 4: {
                if (string == "idiv") {
                    return 50;
                }
                if (string == "then") {
                    return 26;
                }
                if (string == "else") {
                    return 27;
                }
                if (string != "case") break;
                return 59;
            }
            case 5: {
                if (string == "where") {
                    return 28;
                }
                if (string != "union") break;
                return 1;
            }
            case 6: {
                if (string == "except") {
                    return 24;
                }
                if (string != "return") break;
                return 25;
            }
            case 7: {
                if (string == "default") {
                    return 60;
                }
            }
            case 9: {
                if (string == "intersect") {
                    return 23;
                }
                if (string != "satisfies") break;
                return 33;
            }
        }
        return -1;
    }

    private static int getFunctionType(String string) {
        switch (string.length()) {
            case 2: {
                if (string != "if") break;
                return 36;
            }
            case 4: {
                if (string == "node") {
                    return 61;
                }
                if (string == "item") {
                    return 61;
                }
                if (string != "text") break;
                return 61;
            }
            case 7: {
                if (string == "element") {
                    return 61;
                }
                if (string != "comment") break;
                return 61;
            }
            case 9: {
                if (string == "attribute") {
                    return 61;
                }
                if (string != "namespace") break;
                return 61;
            }
            case 10: {
                if (string != "typeswitch") break;
                return 58;
            }
            default: {
                if (string == "document-node") {
                    return 61;
                }
                if (string == "empty-sequence") {
                    return 61;
                }
                if (string == "schema-element") {
                    return 61;
                }
                if (string == "schema-attribute") {
                    return 61;
                }
                if (string != "processing-instruction") break;
                return 61;
            }
        }
        return 34;
    }

    private boolean followsOperator() {
        return this.precedingToken <= Token.LAST_OPERATOR;
    }

    public char nextChar() throws StringIndexOutOfBoundsException {
        char c2;
        if ((c2 = this.input.charAt(this.inputOffset++)) == '\n') {
            this.incrementLineNumber();
            ++this.lineNumber;
        }
        return c2;
    }

    private void incrementLineNumber() {
        ++this.nextLineNumber;
        if (this.newlineOffsets == null) {
            this.newlineOffsets = new ArrayList(20);
        }
        this.newlineOffsets.add(new Integer(this.inputOffset - 1));
    }

    public void unreadChar() {
        if (this.input.charAt(--this.inputOffset) == '\n') {
            --this.nextLineNumber;
            --this.lineNumber;
            if (this.newlineOffsets != null) {
                this.newlineOffsets.remove(this.newlineOffsets.size() - 1);
            }
        }
    }

    public String recentText() {
        if (this.inputOffset > this.inputLength) {
            this.inputOffset = this.inputLength;
        }
        if (this.inputOffset < 34) {
            return this.input.substring(0, this.inputOffset);
        }
        return ((Object)NormalizeSpace.normalize("..." + this.input.substring(this.inputOffset - 30, this.inputOffset))).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return (int)(this.getLineAndColumn(this.currentTokenStartOffset) & Integer.MAX_VALUE);
    }

    public long getLineAndColumn(int n2) {
        if (this.newlineOffsets == null) {
            return (long)this.startLineNumber << 32 | (long)n2;
        }
        for (int i2 = this.newlineOffsets.size() - 1; i2 >= 0; --i2) {
            int n3 = (Integer)this.newlineOffsets.get(i2);
            if (n2 <= n3) continue;
            return (long)(i2 + this.startLineNumber + 1) << 32 | (long)(n2 - n3);
        }
        return (long)this.startLineNumber << 32 | (long)(n2 + 1);
    }

    public int getLineNumber(int n2) {
        return (int)(this.getLineAndColumn(n2) >> 32);
    }

    public int getColumnNumber(int n2) {
        return (int)(this.getLineAndColumn(n2) & Integer.MAX_VALUE);
    }
}

