/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class RangeIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    long start;
    long currentValue;
    int increment;
    long limit;

    public RangeIterator(long l2, long l3) {
        this.start = l2;
        this.increment = l2 <= l3 ? 1 : -1;
        this.currentValue = l2;
        this.limit = l3;
    }

    public boolean hasNext() {
        if (this.increment > 0) {
            return this.currentValue <= this.limit;
        }
        if (this.increment < 0) {
            return this.currentValue >= this.limit;
        }
        return false;
    }

    public Item next() {
        if (!this.hasNext()) {
            this.increment = 0;
            return null;
        }
        long l2 = this.currentValue;
        this.currentValue += (long)this.increment;
        return new IntegerValue(l2);
    }

    public Item current() {
        if (this.increment == 0) {
            return null;
        }
        return new IntegerValue(this.currentValue - (long)this.increment);
    }

    public int position() {
        if (this.increment > 0) {
            return (int)(this.currentValue - this.start);
        }
        if (this.increment < 0) {
            return (int)(this.start - this.currentValue);
        }
        return -1;
    }

    public int getLastPosition() {
        return (int)((this.limit - this.start) * (long)this.increment + 1L);
    }

    public SequenceIterator getAnother() throws XPathException {
        return new RangeIterator(this.start, this.limit);
    }

    public int getProperties() {
        int n2 = 6;
        if (this.increment == 1) {
            n2 |= 1;
        }
        return n2;
    }

    public SequenceIterator getReverseIterator() {
        return new RangeIterator(this.limit, this.start);
    }

    public Value materialize() throws XPathException {
        if (this.increment == 1) {
            return new IntegerRange(this.start, this.limit);
        }
        return new SequenceExtent(this.getAnother());
    }
}

