/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(1, "to", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, "to", 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, false, roleLocator2, staticContext);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        if (this.operand0 instanceof IntegerValue && this.operand1 instanceof IntegerValue) {
            long l2;
            long l3 = ((IntegerValue)this.operand0).longValue();
            if (l3 > (l2 = ((IntegerValue)this.operand1).longValue())) {
                return EmptySequence.getInstance();
            }
            return new IntegerRange(l3, l2);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.INTEGER_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue.compareTo(numericValue2) > 0) {
            return new EmptyIterator();
        }
        return new RangeIterator(numericValue.longValue(), numericValue2.longValue());
    }
}

