/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public final class ItemChecker
extends UnaryExpression {
    private ItemType requiredItemType;
    private RoleLocator role;

    public ItemChecker(Expression expression, ItemType itemType, RoleLocator roleLocator) {
        super(expression);
        this.requiredItemType = itemType;
        this.role = roleLocator;
        this.adoptChildExpression(expression);
    }

    public ItemType getRequiredType() {
        return this.requiredItemType;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.requiredItemType instanceof AnyItemType) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        int n2 = this.operand.getCardinality();
        if (n2 == 8192) {
            return this.operand;
        }
        ItemType itemType2 = this.operand.getItemType(typeHierarchy);
        int n3 = typeHierarchy.relationship(this.requiredItemType, itemType2);
        if (n3 == 0 || n3 == 1) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        if (n3 == 4) {
            if (Cardinality.allowsZero(n2)) {
                String string = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType(typeHierarchy), staticContext.getNamePool());
                staticContext.issueWarning("Warning: the only value that can pass type-checking is an empty sequence. " + string, this);
            } else {
                if (this.requiredItemType == Type.STRING_TYPE && typeHierarchy.isSubType(itemType2, Type.ANY_URI_TYPE)) {
                    if (this.operand instanceof ComputedExpression) {
                        ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
                    }
                    return this.operand;
                }
                String string = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType(typeHierarchy), staticContext.getNamePool());
                StaticError staticError = new StaticError(string);
                staticError.setErrorCode(this.role.getErrorCode());
                staticError.setLocator(this);
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        return this;
    }

    public int getImplementationMethod() {
        int n2 = 6;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            n2 |= 1;
        }
        return n2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        ItemCheckMappingFunction itemCheckMappingFunction = new ItemCheckMappingFunction();
        itemCheckMappingFunction.externalContext = xPathContext;
        return new ItemMappingIterator(sequenceIterator, itemCheckMappingFunction);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        this.testConformance(item, xPathContext);
        return item;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Expression expression = this.operand;
        int n2 = 57344;
        if (expression instanceof CardinalityChecker) {
            n2 = ((CardinalityChecker)expression).getRequiredCardinality();
            expression = ((CardinalityChecker)expression).getBaseExpression();
        }
        if ((expression.getImplementationMethod() & 4) != 0 && !(this.requiredItemType instanceof DocumentNodeTest)) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            TypeCheckingFilter typeCheckingFilter = new TypeCheckingFilter();
            typeCheckingFilter.setUnderlyingReceiver(sequenceReceiver);
            typeCheckingFilter.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
            typeCheckingFilter.setRequiredType(this.requiredItemType, n2, this.role);
            xPathContext.setReceiver(typeCheckingFilter);
            expression.process(xPathContext);
            typeCheckingFilter.close();
            xPathContext.setReceiver(typeCheckingFilter);
        } else {
            super.process(xPathContext);
        }
    }

    private void testConformance(Item item, XPathContext xPathContext) throws XPathException {
        if (!this.requiredItemType.matchesItem(item, xPathContext, true)) {
            Object object;
            String string;
            if (xPathContext == null) {
                string = "Supplied value of type " + Type.displayTypeName(item) + " does not match the required type of " + this.role.getMessage();
            } else {
                object = xPathContext.getNamePool();
                TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
                string = this.role.composeErrorMessage(this.requiredItemType, Value.asValue(item).getItemType(typeHierarchy), (NamePool)object);
            }
            object = this.role.getErrorCode();
            if ("XPDY0050".equals(object)) {
                this.dynamicError(string, (String)object, xPathContext);
            } else {
                this.typeError(string, (String)object, xPathContext);
            }
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.requiredItemType;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredItemType == ((ItemChecker)object).requiredItemType;
    }

    protected String displayOperator(Configuration configuration) {
        return "treat as " + this.requiredItemType.toString(configuration.getNamePool());
    }

    private class ItemCheckMappingFunction
    implements ItemMappingFunction {
        public XPathContext externalContext;

        private ItemCheckMappingFunction() {
        }

        public Item map(Item item) throws XPathException {
            ItemChecker.this.testConformance(item, this.externalContext);
            return item;
        }
    }
}

