/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.trans.XPathException;

public class DifferenceEnumeration
implements SequenceIterator {
    private SequenceIterator p1;
    private SequenceIterator p2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public DifferenceEnumeration(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.p1 = sequenceIterator;
        this.p2 = sequenceIterator2;
        this.comparer = nodeOrderComparer;
        this.nextNode1 = this.next(sequenceIterator);
        this.nextNode2 = this.next(sequenceIterator2);
    }

    private NodeInfo next(SequenceIterator sequenceIterator) throws XPathException {
        return (NodeInfo)sequenceIterator.next();
    }

    public Item next() throws XPathException {
        while (true) {
            if (this.nextNode1 == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.nextNode2 == null) {
                return this.deliver();
            }
            int n2 = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (n2 < 0) {
                return this.deliver();
            }
            if (n2 > 0) {
                this.nextNode2 = this.next(this.p2);
                if (this.nextNode2 != null) continue;
                return this.deliver();
            }
            this.nextNode2 = this.next(this.p2);
            this.nextNode1 = this.next(this.p1);
        }
    }

    private NodeInfo deliver() throws XPathException {
        this.current = this.nextNode1;
        this.nextNode1 = this.next(this.p1);
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new DifferenceEnumeration(this.p1.getAnother(), this.p2.getAnother(), this.comparer);
    }

    public int getProperties() {
        return 0;
    }
}

