/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ClosingAction;
import net.sf.saxon.om.ClosingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleLocator role;

    private CardinalityChecker(Expression expression, int n2, RoleLocator roleLocator) {
        super(expression);
        this.requiredCardinality = n2;
        this.role = roleLocator;
        this.computeStaticProperties();
        this.adoptChildExpression(expression);
    }

    public static ComputedExpression makeCardinalityChecker(Expression expression, int n2, RoleLocator roleLocator) {
        if (expression instanceof Atomizer && !Cardinality.allowsMany(n2)) {
            Expression expression2 = ((Atomizer)expression).getBaseExpression();
            if (expression2 instanceof ComputedExpression) {
                ((ComputedExpression)expression2).setParentExpression(expression.getParentExpression());
            }
            return new SingletonAtomizer(expression2, roleLocator, Cardinality.allowsZero(n2));
        }
        return new CardinalityChecker(expression, n2, roleLocator);
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            if (this.operand instanceof ComputedExpression) {
                ((ComputedExpression)this.operand).setParentExpression(this.getParentExpression());
            }
            return this.operand;
        }
        return this;
    }

    public void setErrorCode(String string) {
        this.role.setErrorCode(string);
    }

    public int getImplementationMethod() {
        int n2 = 6;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            n2 |= 1;
        }
        return n2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if ((sequenceIterator.getProperties() & 2) != 0) {
            int n2 = ((LastPositionFinder)sequenceIterator).getLastPosition();
            if (n2 == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            }
            if (n2 > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            }
            return sequenceIterator;
        }
        if (!Cardinality.allowsZero(this.requiredCardinality)) {
            object = xPathContext;
            ClosingAction closingAction = new ClosingAction((XPathContext)object){
                private final /* synthetic */ XPathContext val$callingContext;
                {
                    this.val$callingContext = xPathContext;
                }

                public void close(SequenceIterator sequenceIterator, int n2) throws XPathException {
                    if (n2 == 0) {
                        CardinalityChecker.this.typeError("An empty sequence is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), this.val$callingContext);
                    }
                }
            };
            sequenceIterator = new ClosingIterator(sequenceIterator, closingAction);
        }
        if (this.requiredCardinality == 8192) {
            return new ItemMappingIterator(sequenceIterator, new EmptyCheckingFunction(xPathContext));
        }
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            object = new CardinalityCheckingFunction(xPathContext);
            ((CardinalityCheckingFunction)object).iterator = sequenceIterator;
            sequenceIterator = new ItemMappingIterator(sequenceIterator, (ItemMappingFunction)object);
        }
        return sequenceIterator;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        Item item2 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (this.requiredCardinality == 8192) {
                this.typeError("An empty sequence is required as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
                return null;
            }
            if (item2 != null) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
                return null;
            }
            item2 = item;
        }
        if (item2 == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            return null;
        }
        return item2;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Expression expression = this.operand;
        ItemType itemType = Type.ITEM_TYPE;
        if (expression instanceof ItemChecker) {
            itemType = ((ItemChecker)expression).getRequiredType();
            expression = ((ItemChecker)expression).getBaseExpression();
        }
        if ((expression.getImplementationMethod() & 4) != 0 && !(itemType instanceof DocumentNodeTest)) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            TypeCheckingFilter typeCheckingFilter = new TypeCheckingFilter();
            typeCheckingFilter.setUnderlyingReceiver(sequenceReceiver);
            typeCheckingFilter.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
            typeCheckingFilter.setRequiredType(itemType, this.requiredCardinality, this.role);
            xPathContext.setReceiver(typeCheckingFilter);
            expression.process(xPathContext);
            typeCheckingFilter.close();
            xPathContext.setReceiver(sequenceReceiver);
        } else {
            super.process(xPathContext);
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.operand.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredCardinality == ((CardinalityChecker)object).requiredCardinality;
    }

    public String displayOperator(Configuration configuration) {
        return "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ')';
    }

    private class EmptyCheckingFunction
    implements ItemMappingFunction {
        public SequenceIterator iterator;
        public XPathContext context;

        public EmptyCheckingFunction(XPathContext xPathContext) {
            this.context = xPathContext;
        }

        public Item map(Item item) throws XPathException {
            CardinalityChecker.this.typeError("An empty sequence is required as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), this.context);
            return null;
        }
    }

    private class CardinalityCheckingFunction
    implements ItemMappingFunction {
        public SequenceIterator iterator;
        public XPathContext context;

        public CardinalityCheckingFunction(XPathContext xPathContext) {
            this.context = xPathContext;
        }

        public Item map(Item item) throws XPathException {
            if (this.iterator.position() == 2) {
                CardinalityChecker.this.typeError("A sequence of more than one item is not allowed as the " + CardinalityChecker.this.role.getMessage(), CardinalityChecker.this.role.getErrorCode(), this.context);
                return null;
            }
            return item;
        }
    }
}

