/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public final class AxisExpression
extends ComputedExpression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    int computedCardinality = -1;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
    }

    public Expression simplify(StaticContext staticContext) {
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            ParentNodeExpression parentNodeExpression = new ParentNodeExpression();
            parentNodeExpression.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, parentNodeExpression);
            return parentNodeExpression;
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        block28: {
            if (itemType == null) {
                StaticError staticError = new StaticError("Axis step " + this.toString(staticContext.getNamePool()) + " cannot be used here: the context item is undefined");
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPDY0002");
                staticError.setLocator(this);
                throw staticError;
            }
            if (itemType instanceof AtomicType) {
                StaticError staticError = new StaticError("Axis step " + this.toString(staticContext.getNamePool()) + " cannot be used here: the context item is an atomic value");
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPTY0020");
                staticError.setLocator(this);
                throw staticError;
            }
            if (itemType instanceof NodeTest) {
                int n2 = itemType.getPrimitiveType();
                if (n2 != 0 && Axis.isAlwaysEmpty(this.axis, n2)) {
                    staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis starting at " + (n2 == 1 || n2 == 2 ? "an " : "a ") + NodeKindTest.toString(n2) + " node will never select anything", this);
                    return EmptySequence.getInstance();
                }
                if (this.test != null) {
                    int n3 = this.test.getPrimitiveType();
                    if (n3 != 0 && !Axis.containsNodeKind(this.axis, n3)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n3) + " nodes", this);
                        return EmptySequence.getInstance();
                    }
                    if (this.axis == 12 && n3 != 0 && n2 != 0 && n3 != n2) {
                        staticContext.issueWarning("The self axis will never select any " + NodeKindTest.toString(n2) + " nodes when starting at " + (n2 == 1 || n2 == 2 ? "an " : "a ") + NodeKindTest.toString(n3) + " node", this);
                        return EmptySequence.getInstance();
                    }
                    if (this.axis == 12) {
                        this.itemType = itemType;
                    }
                    if (itemType instanceof DocumentNodeTest && this.axis == 3 && n3 == 1) {
                        IntHashSet intHashSet;
                        NodeTest nodeTest = ((DocumentNodeTest)itemType).getElementTest();
                        IntHashSet intHashSet2 = nodeTest.getRequiredNodeNames();
                        if (intHashSet2 != null && (intHashSet = this.test.getRequiredNodeNames()) != null && intHashSet.intersect(intHashSet2).isEmpty()) {
                            staticContext.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this);
                            return EmptySequence.getInstance();
                        }
                        this.itemType = nodeTest;
                        return this;
                    }
                    SchemaType schemaType = ((NodeTest)itemType).getContentType();
                    if (schemaType == AnyType.getInstance()) {
                        return this;
                    }
                    int n4 = this.test.getFingerprint();
                    if (schemaType.isSimpleType()) {
                        if (!(this.axis != 3 && this.axis != 2 && this.axis != 4 && this.axis != 5 || n3 != 1 && n3 != 2 && n3 != 9)) {
                            staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n3) + " nodes when starting at a node with simple type " + schemaType.getDescription(), this);
                        }
                    } else if (!(!((ComplexType)schemaType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || n3 != 1 && n3 != 9)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n3) + " nodes when starting at a node with type " + schemaType.getDescription() + ", as this type requires simple content", this);
                    } else if (((ComplexType)schemaType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + " nodes when starting at a node with type " + schemaType.getDescription() + ", as this type requires empty content", this);
                    } else if (this.axis == 2 && n4 != -1) {
                        try {
                            SchemaType schemaType2 = ((ComplexType)schemaType).getAttributeUseType(n4);
                            if (schemaType2 == null) {
                                String string = staticContext.getNamePool().getDisplayName(n4);
                                staticContext.issueWarning("The complex type " + schemaType.getDescription() + " does not allow an attribute named " + string, this);
                                break block28;
                            }
                            this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType2, staticContext.getConfiguration()));
                        }
                        catch (SchemaException schemaException) {}
                    } else if (this.axis == 3 && n3 == 1 && n4 != -1) {
                        try {
                            SchemaType schemaType3 = ((ComplexType)schemaType).getElementParticleType(n4);
                            if (schemaType3 == null) {
                                String string = staticContext.getNamePool().getDisplayName(n4);
                                staticContext.issueWarning("The complex type " + schemaType.getDescription() + " does not allow a child element named " + string, this);
                            } else {
                                this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType3, staticContext.getConfiguration()));
                                this.computedCardinality = ((ComplexType)schemaType).getElementParticleCardinality(n4);
                                this.resetStaticProperties();
                            }
                        }
                        catch (SchemaException schemaException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)object).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)object).test == null;
        }
        return this.test.toString().equals(((AxisExpression)object).test.toString());
    }

    public int hashCode() {
        int n2 = 9375162 + this.axis << 20;
        if (this.test != null) {
            n2 ^= this.test.getPrimitiveType() << 16;
            n2 ^= this.test.getFingerprint();
        }
        return n2;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0xC10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType != null) {
            return this.itemType;
        }
        short s2 = Axis.principalNodeType[this.axis];
        switch (s2) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(s2);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    public final int computeCardinality() {
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        if (this.axis == 2 && this.test instanceof NameTest) {
            return 24576;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (NullPointerException nullPointerException) {
            NamePool namePool = null;
            try {
                namePool = xPathContext.getConfiguration().getNamePool();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicError dynamicError = new DynamicError("The context item for axis step " + (namePool == null ? this.toString() : this.toString(namePool)) + " is undefined");
            dynamicError.setErrorCode("XPDY0002");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        catch (ClassCastException classCastException) {
            NamePool namePool = null;
            try {
                namePool = xPathContext.getConfiguration().getNamePool();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicError dynamicError = new DynamicError("The context item for axis step " + (namePool == null ? this.toString() : this.toString(namePool)) + " is not a node");
            dynamicError.setErrorCode("XPTY0020");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.dynamicError(unsupportedOperationException.getMessage(), "XPST0010", xPathContext);
            return null;
        }
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + this.toString(configuration.getNamePool()));
    }

    public String toString() {
        return Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString());
    }

    public String toString(NamePool namePool) {
        return Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString(namePool));
    }
}

