/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;

public abstract class Assignation
extends ComputedExpression
implements Binding {
    protected int slotNumber = -999;
    protected Expression sequence;
    protected Expression action;
    protected String variableName;
    protected int nameCode;
    protected transient RangeVariableDeclaration declaration;

    public void setVariableDeclaration(RangeVariableDeclaration rangeVariableDeclaration) {
        this.declaration = rangeVariableDeclaration;
        this.nameCode = rangeVariableDeclaration.getNameCode();
        this.variableName = rangeVariableDeclaration.getVariableName();
    }

    public RangeVariableDeclaration getVariableDeclaration() {
        return this.declaration;
    }

    public void setAction(Expression expression) {
        this.action = expression;
        if (this.declaration != null) {
            this.declaration.fixupReferences(this);
        }
        this.adoptChildExpression(expression);
    }

    public final boolean isGlobal() {
        return false;
    }

    public final boolean isAssignable() {
        return false;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public Expression getAction() {
        return this.action;
    }

    public void setSequence(Expression expression) {
        this.sequence = expression;
        this.adoptChildExpression(expression);
    }

    public void setSlotNumber(int n2) {
        this.slotNumber = n2;
    }

    public int getRequiredSlots() {
        return 1;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.doPromotion(this.sequence, promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13 || promotionOffer.action == 14) {
            this.action = this.doPromotion(this.action, promotionOffer);
        } else if (promotionOffer.action == 11) {
            Binding[] bindingArray = promotionOffer.bindingList;
            Binding[] bindingArray2 = this.extendBindingList(promotionOffer.bindingList);
            promotionOffer.bindingList = bindingArray2;
            this.action = this.doPromotion(this.action, promotionOffer);
            promotionOffer.bindingList = bindingArray;
        }
        return this;
    }

    public void suppressValidation(int n2) {
        if (this.action instanceof ComputedExpression) {
            ((ComputedExpression)this.action).suppressValidation(n2);
        }
    }

    protected Binding[] extendBindingList(Binding[] bindingArray) {
        Binding[] bindingArray2 = new Binding[bindingArray.length + 1];
        System.arraycopy(bindingArray, 0, bindingArray2, 0, bindingArray.length);
        bindingArray2[bindingArray.length] = this;
        return bindingArray2;
    }

    protected Expression promoteWhereClause(Binding binding) {
        if (this.action instanceof IfExpression) {
            Container container = this.getParentExpression();
            IfExpression ifExpression = (IfExpression)this.action;
            Expression expression = ifExpression.getCondition();
            Expression expression2 = ifExpression.getElseExpression();
            if (expression2 instanceof EmptySequence) {
                Binding[] bindingArray;
                Object object;
                if (binding == null) {
                    object = new Binding[]{this};
                    bindingArray = object;
                } else {
                    object = new Binding[]{this, binding};
                    bindingArray = object;
                }
                object = new ArrayList(5);
                Expression expression3 = null;
                BooleanExpression.listAndComponents(expression, (List)object);
                for (int i2 = object.size() - 1; i2 >= 0; --i2) {
                    Expression expression4 = (Expression)object.get(i2);
                    if (ExpressionTool.dependsOnVariable(expression4, bindingArray)) continue;
                    expression3 = expression3 == null ? expression4 : new BooleanExpression(expression4, 10, expression3);
                    object.remove(i2);
                }
                if (expression3 != null) {
                    if (object.size() == 0) {
                        Expression expression5 = ifExpression.getThenExpression();
                        this.setAction(expression5);
                        ifExpression.setParentExpression(container);
                        ifExpression.setThenExpression(this);
                        return ifExpression;
                    }
                    Expression expression6 = (Expression)object.get(0);
                    for (int i3 = 1; i3 < object.size(); ++i3) {
                        expression6 = new BooleanExpression(expression6, 10, (Expression)object.get(i3));
                    }
                    ifExpression.setCondition(expression6);
                    IfExpression ifExpression2 = new IfExpression(expression3, this, EmptySequence.getInstance());
                    ifExpression2.setParentExpression(container);
                    return ifExpression2;
                }
            }
        }
        return null;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.sequence, this.action);
    }

    public int getVariableNameCode() {
        return this.nameCode;
    }

    public int getVariableFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public String getVariableName(NamePool namePool) {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName;
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = xPathContext.evaluateLocalVariable(this.slotNumber);
        if (valueRepresentation instanceof MemoClosure && ((MemoClosure)valueRepresentation).isFullyRead()) {
            valueRepresentation = ((MemoClosure)valueRepresentation).materialize();
            xPathContext.setLocalVariable(this.slotNumber, valueRepresentation);
        }
        return valueRepresentation;
    }
}

