/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class UncommittedSerializer
extends ProxyReceiver {
    boolean committed = false;
    List pending = null;
    Result finalResult;
    Properties outputProperties;

    public UncommittedSerializer(Result result, Properties properties) {
        this.finalResult = result;
        this.outputProperties = properties;
        this.setUnderlyingReceiver(new Sink());
    }

    public void open() throws XPathException {
        this.committed = false;
    }

    public void close() throws XPathException {
        if (!this.committed) {
            this.switchToMethod("xml");
        }
        this.getUnderlyingReceiver().close();
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().characters(charSequence, n2, n3);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 3;
            pendingNode.name = null;
            pendingNode.content = ((Object)charSequence).toString();
            pendingNode.locationId = n2;
            pendingNode.properties = n3;
            this.pending.add(pendingNode);
            if (!Whitespace.isWhite(charSequence)) {
                this.switchToMethod("xml");
            }
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().processingInstruction(string, charSequence, n2, n3);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 7;
            pendingNode.name = string;
            pendingNode.content = charSequence;
            pendingNode.locationId = n2;
            pendingNode.properties = n3;
            this.pending.add(pendingNode);
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().comment(charSequence, n2, n3);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList(10);
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 8;
            pendingNode.name = null;
            pendingNode.content = charSequence;
            pendingNode.locationId = n2;
            pendingNode.properties = n3;
            this.pending.add(pendingNode);
        }
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        if (!this.committed) {
            NamePool namePool = this.getNamePool();
            String string = namePool.getLocalName(n2);
            short s2 = namePool.getURICode(n2);
            if (string.equalsIgnoreCase("html") && s2 == 0) {
                this.switchToMethod("html");
            } else if (string.equals("html") && namePool.getURIFromURICode(s2).equals("http://www.w3.org/1999/xhtml")) {
                String string2 = this.outputProperties.getProperty("{http://saxon.sf.net/}stylesheet-version");
                if ("1".equals(string2)) {
                    this.switchToMethod("xml");
                } else {
                    this.switchToMethod("xhtml");
                }
            } else {
                this.switchToMethod("xml");
            }
        }
        this.getUnderlyingReceiver().startElement(n2, n3, n4, n5);
    }

    private void switchToMethod(String string) throws XPathException {
        Properties properties = new Properties(this.outputProperties);
        properties.setProperty("method", string);
        Receiver receiver = SerializerFactory.getReceiver(this.finalResult, this.getPipelineConfiguration(), properties);
        this.committed = true;
        receiver.open();
        receiver.startDocument(0);
        if (this.pending != null) {
            block5: for (int i2 = 0; i2 < this.pending.size(); ++i2) {
                PendingNode pendingNode = (PendingNode)this.pending.get(i2);
                switch (pendingNode.kind) {
                    case 8: {
                        receiver.comment(pendingNode.content, pendingNode.locationId, pendingNode.properties);
                        continue block5;
                    }
                    case 7: {
                        receiver.processingInstruction(pendingNode.name, pendingNode.content, pendingNode.locationId, pendingNode.properties);
                        continue block5;
                    }
                    case 3: {
                        receiver.characters(pendingNode.content, pendingNode.locationId, pendingNode.properties);
                    }
                }
            }
            this.pending = null;
        }
        this.setUnderlyingReceiver(receiver);
    }

    private static final class PendingNode {
        int kind;
        String name;
        CharSequence content;
        int properties;
        int locationId;

        private PendingNode() {
        }
    }
}

