/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public abstract class SequenceWriter
extends SequenceReceiver {
    private String systemId;
    private Receiver tree = null;
    private TinyBuilder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public abstract void write(Item var1) throws XPathException;

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean hasOpenNodes() {
        return this.level != 0;
    }

    public void startDocument(int n2) throws XPathException {
        if (this.tree == null) {
            this.createTree();
        }
        if (this.level++ == 0) {
            this.tree.startDocument(n2);
        }
    }

    private void createTree() throws XPathException {
        this.builder = new TinyBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(this.builder);
        namespaceReducer.setPipelineConfiguration(this.getPipelineConfiguration());
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setHostLanguage(this.getPipelineConfiguration().getHostLanguage());
        complexContentOutputter.setPipelineConfiguration(this.getPipelineConfiguration());
        complexContentOutputter.setReceiver(namespaceReducer);
        this.tree = complexContentOutputter;
        this.tree.setSystemId(this.systemId);
        this.tree.setPipelineConfiguration(this.getPipelineConfiguration());
        this.tree.open();
    }

    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.tree.endDocument();
            DocumentInfo documentInfo = (DocumentInfo)this.builder.getCurrentRoot();
            this.append(documentInfo, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            this.createTree();
        }
        this.tree.startElement(n2, n3, n4, n5);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.tree.endElement();
        if (--this.level == 0) {
            NodeInfo nodeInfo = this.builder.getCurrentRoot();
            this.append(nodeInfo, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void namespace(int n2, int n3) throws XPathException {
        if (this.level == 0) {
            NamePool namePool = this.getNamePool();
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)13);
            orphan.setNameCode(namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n2)));
            orphan.setStringValue(namePool.getURIFromNamespaceCode(n2));
            this.append(orphan, 0, 2);
        } else {
            this.tree.namespace(n2, n3);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)2);
            orphan.setNameCode(n2);
            orphan.setStringValue(charSequence);
            orphan.setTypeAnnotation(n3);
            this.append(orphan, n4, 2);
        } else {
            this.tree.attribute(n2, n3, charSequence, n4, n5);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.tree.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            this.append(orphan, n2, 2);
        } else if (charSequence.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.tree.characters(charSequence, n2, n3);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)8);
            orphan.setStringValue(charSequence);
            this.append(orphan, n2, 2);
        } else {
            this.tree.comment(charSequence, n2, n3);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNameCode(this.getNamePool().allocate("", "", string));
            orphan.setNodeKind((short)7);
            orphan.setStringValue(charSequence);
            this.append(orphan, n2, 2);
        } else {
            this.tree.processingInstruction(string, charSequence, n2, n3);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.tree != null) {
            this.tree.close();
        }
    }

    public void append(Item item, int n2, int n3) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.level == 0) {
            this.write(item);
            this.previousAtomic = false;
        } else if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.tree.characters(" ", 0, 0);
            }
            this.tree.characters(item.getStringValueCS(), 0, 0);
            this.previousAtomic = true;
        } else {
            ((NodeInfo)item).copy(this.tree, 2, true, n2);
            this.previousAtomic = false;
        }
    }
}

