/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.StringTokenizer;
import net.sf.saxon.Err;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.DynamicError;

public class SaxonOutputKeys {
    public static final String INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String STYLESHEET_VERSION = "{http://saxon.sf.net/}stylesheet-version";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attibutes";
    public static final String CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String NEXT_IN_CHAIN_BASE_URI = "{http://saxon.sf.net/}next-in-chain-base-uri";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String WRAP = "{http://saxon.sf.net/}wrap-result-sequence";

    private SaxonOutputKeys() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkOutputProperty(String string, String string2, NameChecker nameChecker) throws DynamicError {
        if (string.startsWith("{") && !string.startsWith("{http://saxon.sf.net/}")) return;
        if (string.equals("cdata-section-elements")) {
            if (string2 == null) return;
            SaxonOutputKeys.checkListOfClarkNames(string, string2, nameChecker);
            return;
        } else {
            if (string.equals("doctype-public") || string.equals("doctype-system") || string.equals("encoding")) return;
            if (string.equals("indent")) {
                if (string2 == null) return;
                SaxonOutputKeys.checkYesOrNo(string, string2);
                return;
            } else {
                if (string.equals("media-type")) return;
                if (string.equals("method")) {
                    if (string2 == null) return;
                    SaxonOutputKeys.checkMethod(string2, nameChecker);
                    return;
                } else if (string.equals("omit-xml-declaration")) {
                    if (string2 == null) return;
                    SaxonOutputKeys.checkYesOrNo(string, string2);
                    return;
                } else if (string.equals("standalone")) {
                    if (string2 == null || string2.equals("omit")) return;
                    SaxonOutputKeys.checkYesOrNo(string, string2);
                    return;
                } else {
                    if (string.equals("version") || string.equals(STYLESHEET_VERSION)) return;
                    if (string.equals(INDENT_SPACES)) {
                        if (string2 == null) return;
                        SaxonOutputKeys.checkNonNegativeInteger(string, string2);
                        return;
                    } else if (string.equals(INCLUDE_CONTENT_TYPE)) {
                        if (string2 == null) return;
                        SaxonOutputKeys.checkYesOrNo(string, string2);
                        return;
                    } else if (string.equals(ESCAPE_URI_ATTRIBUTES)) {
                        if (string2 == null) return;
                        SaxonOutputKeys.checkYesOrNo(string, string2);
                        return;
                    } else {
                        if (string.equals(CHARACTER_REPRESENTATION) || string.equals(NEXT_IN_CHAIN) || string.equals(NEXT_IN_CHAIN_BASE_URI)) return;
                        if (string.equals(UNDECLARE_PREFIXES)) {
                            if (string2 == null) return;
                            SaxonOutputKeys.checkYesOrNo(string, string2);
                            return;
                        } else if (string.equals(USE_CHARACTER_MAPS)) {
                            if (string2 == null) return;
                            SaxonOutputKeys.checkListOfClarkNames(string, string2, nameChecker);
                            return;
                        } else if (string.equals(REQUIRE_WELL_FORMED)) {
                            if (string2 == null) return;
                            SaxonOutputKeys.checkYesOrNo(string, string2);
                            return;
                        } else if (string.equals(BYTE_ORDER_MARK)) {
                            if (string2 == null) return;
                            SaxonOutputKeys.checkYesOrNo(string, string2);
                            return;
                        } else {
                            if (!string.equals(WRAP)) throw new DynamicError("Unknown serialization parameter " + Err.wrap(string));
                            if (string2 == null) return;
                            SaxonOutputKeys.checkYesOrNo(string, string2);
                        }
                    }
                }
            }
        }
    }

    private static void checkYesOrNo(String string, String string2) throws DynamicError {
        if (!"yes".equals(string2) && !"no".equals(string2)) {
            throw new DynamicError("Serialization parameter " + Err.wrap(string) + " must have the value yes or no");
        }
    }

    private static void checkMethod(String string, NameChecker nameChecker) throws DynamicError {
        if ("xml".equals(string)) {
            return;
        }
        if ("html".equals(string)) {
            return;
        }
        if ("xhtml".equals(string)) {
            return;
        }
        if ("text".equals(string)) {
            return;
        }
        if (SaxonOutputKeys.isValidClarkName(string, nameChecker)) {
            return;
        }
        throw new DynamicError("Invalid value for serialization method: must be xml, html, xhtml, text, or a QName in '{uri}local' form");
    }

    private static boolean isValidClarkName(String string, NameChecker nameChecker) {
        if (string.charAt(0) != '{') {
            return false;
        }
        int n2 = string.indexOf(125);
        if (n2 < 2) {
            return false;
        }
        if (n2 == string.length() - 1) {
            return false;
        }
        return nameChecker.isValidNCName(string.substring(n2 + 1));
    }

    private static void checkNonNegativeInteger(String string, String string2) throws DynamicError {
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 < 0) {
                throw new DynamicError("Value of " + Err.wrap(string) + " must be a non-negative integer");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DynamicError("Value of " + Err.wrap(string) + " must be a non-negative integer");
        }
    }

    private static void checkListOfClarkNames(String string, String string2, NameChecker nameChecker) throws DynamicError {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (SaxonOutputKeys.isValidClarkName(string3, nameChecker) || nameChecker.isValidNCName(string3)) continue;
            throw new DynamicError("Value of " + Err.wrap(string) + " must be a list of QNames in '{uri}local' notation");
        }
    }
}

