/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public abstract class ProxyReceiver
extends SequenceReceiver {
    protected Receiver nextReceiver;
    protected String systemId;

    public void setSystemId(String string) {
        if (string != this.systemId) {
            this.systemId = string;
            if (this.nextReceiver != null) {
                this.nextReceiver.setSystemId(string);
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        if (receiver != this.nextReceiver) {
            this.nextReceiver = receiver;
            if (this.pipelineConfiguration != null) {
                this.nextReceiver.setPipelineConfiguration(this.pipelineConfiguration);
            }
        }
    }

    public Receiver getUnderlyingReceiver() {
        return this.nextReceiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        if (this.pipelineConfiguration != pipelineConfiguration) {
            this.pipelineConfiguration = pipelineConfiguration;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipelineConfiguration);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.pipelineConfiguration.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public void open() throws XPathException {
        if (this.nextReceiver == null) {
            throw new IllegalStateException("ProxyReceiver.open(): no underlying receiver provided");
        }
        this.nextReceiver.open();
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
    }

    public void startDocument(int n2) throws XPathException {
        this.nextReceiver.startDocument(n2);
    }

    public void endDocument() throws XPathException {
        this.nextReceiver.endDocument();
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        this.nextReceiver.startElement(n2, n3, n4, n5);
    }

    public void namespace(int n2, int n3) throws XPathException {
        this.nextReceiver.namespace(n2, n3);
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        this.nextReceiver.attribute(n2, n3, charSequence, n4, n5);
    }

    public void startContent() throws XPathException {
        this.nextReceiver.startContent();
    }

    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.nextReceiver.characters(charSequence, n2, n3);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        this.nextReceiver.processingInstruction(string, charSequence, n2, n3);
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.nextReceiver.comment(charSequence, n2, n3);
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
        this.nextReceiver.setUnparsedEntity(string, string2, string3);
    }

    public LocationProvider getDocumentLocator() {
        return this.pipelineConfiguration.getLocationProvider();
    }
}

