/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class MetaTagAdjuster
extends ProxyReceiver {
    boolean seekingHead = true;
    int droppingMetaTags = -1;
    boolean inMetaTag = false;
    boolean foundHead = false;
    int metaCode;
    short requiredURICode = 0;
    AttributeCollectionImpl attributes;
    String encoding;
    String mediaType;
    int level = 0;
    boolean isXHTML = false;

    public void setOutputProperties(Properties properties) throws XPathException {
        this.encoding = properties.getProperty("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.mediaType = properties.getProperty("media-type");
        if (this.mediaType == null) {
            this.mediaType = "text/html";
        }
    }

    public void setIsXHTML(boolean bl) {
        this.isXHTML = bl;
        this.requiredURICode = bl ? this.getNamePool().getCodeForURI("http://www.w3.org/1999/xhtml") : (short)0;
    }

    private boolean comparesEqual(String string, String string2) {
        if (this.isXHTML) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        if (this.droppingMetaTags == this.level) {
            this.metaCode = n2;
            short s2 = this.getNamePool().getURICode(n2);
            String string = this.getNamePool().getLocalName(n2);
            if (s2 == this.requiredURICode && this.comparesEqual(string, "meta")) {
                this.inMetaTag = true;
                this.attributes.clear();
                return;
            }
        }
        ++this.level;
        super.startElement(n2, n3, n4, n5);
        if (this.seekingHead) {
            NamePool namePool = this.getNamePool();
            short s3 = namePool.getURICode(n2);
            String string = namePool.getLocalName(n2);
            if (s3 == this.requiredURICode && this.comparesEqual(string, "head")) {
                this.foundHead = true;
            }
        }
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.inMetaTag) {
            this.attributes.addAttribute(n2, n3, ((Object)charSequence).toString(), n4, n5);
        } else {
            super.attribute(n2, n3, charSequence, n4, n5);
        }
    }

    public void startContent() throws XPathException {
        if (this.foundHead) {
            this.foundHead = false;
            NamePool namePool = this.getNamePool();
            super.startContent();
            int n2 = namePool.allocate("", this.requiredURICode, "meta");
            super.startElement(n2, 641, 0, 0);
            int n3 = namePool.allocate("", "", "http-equiv");
            super.attribute(n3, 642, "Content-Type", 0, 0);
            int n4 = namePool.allocate("", "", "content");
            super.attribute(n4, 642, this.mediaType + "; charset=" + this.encoding, 0, 0);
            super.startContent();
            this.droppingMetaTags = this.level;
            this.seekingHead = false;
            this.attributes = new AttributeCollectionImpl(namePool);
            super.endElement();
        }
        if (!this.inMetaTag) {
            super.startContent();
        }
    }

    public void endElement() throws XPathException {
        if (this.inMetaTag) {
            int n2;
            this.inMetaTag = false;
            boolean bl = false;
            for (n2 = 0; n2 < this.attributes.getLength(); ++n2) {
                String string;
                String string2 = this.attributes.getLocalName(n2);
                if (!this.comparesEqual(string2, "http-equiv") || !(string = this.attributes.getValue(n2).trim()).equalsIgnoreCase("Content-Type")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                super.startElement(this.metaCode, 641, 0, 0);
                for (n2 = 0; n2 < this.attributes.getLength(); ++n2) {
                    int n3 = this.attributes.getNameCode(n2);
                    int n4 = this.attributes.getTypeAnnotation(n2);
                    String string = this.attributes.getValue(n2);
                    int n5 = this.attributes.getLocationId(n2);
                    int n6 = this.attributes.getProperties(n2);
                    super.attribute(n3, n4, string, n5, n6);
                }
                super.startContent();
                super.endElement();
            }
        } else {
            --this.level;
            if (this.droppingMetaTags == this.level + 1) {
                this.droppingMetaTags = -1;
            }
            super.endElement();
        }
    }
}

