/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class IDFilter
extends StartTagBuffer {
    private String requiredId;
    private int activeDepth = 0;
    private boolean matched = false;
    private IntHashSet nonIDs;

    public IDFilter(String string) {
        this.requiredId = string;
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        this.matched = false;
        if (this.activeDepth > 0) {
            ++this.activeDepth;
        }
        super.startElement(n2, n3, n4, n5);
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        super.attribute(n2, n3, charSequence, n4, n5);
        if (((n2 & 0xFFFFF) == 388 || this.isIDCode(n3)) && ((Object)charSequence).toString().equals(this.requiredId)) {
            this.matched = true;
        }
    }

    public void startContent() throws XPathException {
        if (this.activeDepth > 0) {
            super.startContent();
        } else if (this.matched) {
            this.activeDepth = 1;
            super.startContent();
        }
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        if (this.activeDepth == 1) {
            this.declareAllNamespaces();
        } else {
            super.declareNamespacesForStartElement();
        }
    }

    public void endElement() throws XPathException {
        if (this.activeDepth > 0) {
            super.endElement();
            --this.activeDepth;
        } else {
            this.undeclareNamespacesForElement();
        }
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.activeDepth > 0) {
            super.characters(charSequence, n2, n3);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.activeDepth > 0) {
            super.processingInstruction(string, charSequence, n2, n3);
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.activeDepth > 0) {
            super.comment(charSequence, n2, n3);
        }
    }

    private boolean isIDCode(int n2) {
        if ((n2 & 0xFFFFF) == 560) {
            return true;
        }
        if (n2 < 1024) {
            return false;
        }
        if (this.nonIDs == null) {
            this.nonIDs = new IntHashSet(20);
        }
        if (this.nonIDs.contains(n2)) {
            return false;
        }
        SchemaType schemaType = this.getConfiguration().getSchemaType(n2);
        if (schemaType instanceof AtomicType) {
            if (this.getConfiguration().getTypeHierarchy().isSubType((AtomicType)schemaType, Type.ID_TYPE)) {
                return true;
            }
            this.nonIDs.add(n2);
            return false;
        }
        return false;
    }
}

