/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import java.util.Properties;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private int[] propertyStack = new int[20];
    protected static String[] inlineTags;
    private static HTMLTagHashSet inlineTable;
    protected static final int IS_INLINE = 1;
    protected static final int IS_FORMATTED = 2;
    private static HTMLTagHashSet formattedTable;
    protected static String[] formattedTags;

    protected int classifyTag(int n2) {
        int n3 = 0;
        String string = this.getNamePool().getDisplayName(n2);
        if (inlineTable.contains(string)) {
            n3 |= 1;
        }
        if (formattedTable.contains(string)) {
            n3 |= 2;
        }
        return n3;
    }

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        int n6 = this.classifyTag(n2);
        if (this.level >= this.propertyStack.length) {
            int[] nArray = new int[this.level * 2];
            System.arraycopy(this.propertyStack, 0, nArray, 0, this.propertyStack.length);
            this.propertyStack = nArray;
        }
        this.propertyStack[this.level] = n6;
        this.isInlineTag = (n6 & 1) != 0;
        boolean bl = this.inFormattedTag = this.inFormattedTag || (n6 & 2) != 0;
        if (!(this.isInlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        super.startElement(n2, n3, n4, n5);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement() throws XPathException {
        boolean bl;
        --this.level;
        boolean bl2 = (this.propertyStack[this.level] & 1) != 0;
        boolean bl3 = bl = (this.propertyStack[this.level] & 2) != 0;
        if (!(bl2 || bl || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = bl2;
            this.afterFormatted = bl;
        }
        super.endElement();
        this.inFormattedTag = this.inFormattedTag && !bl;
        this.sameLine = false;
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.inFormattedTag || (n3 & 0x100) != 0) {
            super.characters(charSequence, n2, n3);
        } else {
            int n4 = 0;
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (charSequence.charAt(i2) != '\n' && (i2 - n4 <= 120 || charSequence.charAt(i2) != ' ')) continue;
                this.sameLine = false;
                super.characters(charSequence.subSequence(n4, i2), n2, n3);
                this.indent();
                for (n4 = i2 + 1; n4 < charSequence.length() && charSequence.charAt(n4) == ' '; ++n4) {
                }
            }
            if (n4 < charSequence.length()) {
                super.characters(charSequence.subSequence(n4, charSequence.length()), n2, n3);
            }
        }
        this.afterInline = false;
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.indent();
        super.comment(charSequence, n2, n3);
    }

    private void indent() throws XPathException {
        int n2 = this.level * this.indentSpaces;
        if (n2 + 1 >= this.indentChars.length) {
            int n3 = 5 * this.indentSpaces;
            if (n2 + 1 > this.indentChars.length + n3) {
                n3 += n2 + 1;
            }
            char[] cArray = new char[this.indentChars.length + n3];
            System.arraycopy(this.indentChars, 0, cArray, 0, this.indentChars.length);
            Arrays.fill(cArray, this.indentChars.length, cArray.length, ' ');
            this.indentChars = cArray;
        }
        super.characters(new CharSlice(this.indentChars, 0, n2 + 1), 0, 0);
        this.sameLine = false;
    }

    static {
        int n2;
        inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"};
        inlineTable = new HTMLTagHashSet(101);
        for (n2 = 0; n2 < inlineTags.length; ++n2) {
            inlineTable.add(inlineTags[n2]);
        }
        formattedTable = new HTMLTagHashSet(23);
        formattedTags = new String[]{"pre", "script", "style", "textarea", "xmp"};
        for (n2 = 0; n2 < formattedTags.length; ++n2) {
            formattedTable.add(formattedTags[n2]);
        }
    }
}

