/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class CharacterMapExpander
extends ProxyReceiver {
    private IntHashMap charMap;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean mapsWhitespace = false;
    private boolean useNullMarkers = true;

    public void setCharacterMaps(List list) {
        this.charMap = new IntHashMap(64);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IntHashMap intHashMap = (IntHashMap)list.get(i2);
            IntIterator intIterator = intHashMap.keyIterator();
            while (intIterator.hasNext()) {
                int n2 = intIterator.next();
                if (n2 < this.min) {
                    this.min = n2;
                }
                if (n2 > this.max) {
                    this.max = n2;
                }
                if (!this.mapsWhitespace && Whitespace.isWhitespace(n2)) {
                    this.mapsWhitespace = true;
                }
                this.charMap.put(n2, intHashMap.get(n2));
            }
        }
        if (this.min > 55296) {
            this.min = 55296;
        }
    }

    public void setUseNullMarkers(boolean bl) {
        this.useNullMarkers = bl;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if ((n5 & 2) == 0) {
            CharSequence charSequence2 = this.map(charSequence, this.useNullMarkers);
            if (charSequence2 == charSequence) {
                super.attribute(n2, n3, charSequence, n4, n5);
            } else {
                super.attribute(n2, n3, charSequence2, n4, (n5 | 0x100) & 0xFFFFFFFB);
            }
        } else {
            super.attribute(n2, n3, charSequence, n4, n5);
        }
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if ((n3 & 1) == 0) {
            CharSequence charSequence2 = this.map(charSequence, this.useNullMarkers);
            if (charSequence2 != charSequence) {
                n3 = (n3 | 0x100) & 0xFFFFFFFB;
            }
            super.characters(charSequence2, n2, n3);
        } else {
            super.characters(charSequence, n2, n3);
        }
    }

    private CharSequence map(CharSequence charSequence, boolean bl) {
        int n2;
        if (!this.mapsWhitespace && charSequence instanceof CompressedWhitespace) {
            return charSequence;
        }
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < charSequence.length()) {
            if ((n2 = charSequence.charAt(n3++)) < this.min || n2 > this.max) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 2);
        n2 = 0;
        while (n2 < charSequence.length()) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) >= this.min && c2 <= this.max) {
                if (XMLChar.isHighSurrogate(c2)) {
                    char c3;
                    int n4;
                    String string;
                    if ((string = (String)this.charMap.get(n4 = XMLChar.supplemental(c2, c3 = charSequence.charAt(n2++)))) == null) {
                        fastStringBuffer.append(c2);
                        fastStringBuffer.append(c3);
                        continue;
                    }
                    if (bl) {
                        fastStringBuffer.append('\u0000');
                        fastStringBuffer.append(string);
                        fastStringBuffer.append('\u0000');
                        continue;
                    }
                    fastStringBuffer.append(string);
                    continue;
                }
                String string = (String)this.charMap.get(c2);
                if (string == null) {
                    fastStringBuffer.append(c2);
                    continue;
                }
                if (bl) {
                    fastStringBuffer.append('\u0000');
                    fastStringBuffer.append(string);
                    fastStringBuffer.append('\u0000');
                    continue;
                }
                fastStringBuffer.append(string);
                continue;
            }
            fastStringBuffer.append(c2);
        }
        return fastStringBuffer;
    }
}

