/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class AttrOverNodeInfo
extends NodeOverNodeInfo
implements Attr {
    public String getName() {
        return this.node.getDisplayName();
    }

    public String getValue() {
        return this.node.getStringValue();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        AttrOverNodeInfo.disallowUpdate();
    }

    public boolean isId() {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(560);
        ContentTypeTest contentTypeTest = new ContentTypeTest(2, schemaType, this.node.getConfiguration());
        contentTypeTest.setMatchDTDTypes(true);
        return contentTypeTest.matches(this.node);
    }

    public Element getOwnerElement() {
        if (this.node.getNodeKind() != 2) {
            throw new UnsupportedOperationException("This method is defined only on attribute nodes");
        }
        return (Element)((Object)AttrOverNodeInfo.wrap(this.node.getParent()));
    }

    public TypeInfo getSchemaTypeInfo() {
        int n2 = this.node.getTypeAnnotation();
        if (n2 == -1 || (n2 & 0x40000000) != 0) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), this.node.getConfiguration().getSchemaType(n2));
    }
}

