/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;

class UnicodeDataGenerator {
    static final String copyright = "Copyright \u00a9 1998-1999 Unicode, Inc.";
    private static final boolean DEBUG = false;
    private static String dir;
    private static String UNICODE_DATA;
    private static String COMPOSITION_EXCLUSIONS;
    private static List canonicalClassKeys;
    private static List canonicalClassValues;
    private static List decompositionKeys;
    private static List decompositionValues;
    private static List exclusionList;
    private static List compatibilityList;

    private UnicodeDataGenerator() {
    }

    static void build() {
        try {
            UnicodeDataGenerator.readExclusionList();
            UnicodeDataGenerator.buildDecompositionTables();
        }
        catch (IOException iOException) {
            System.err.println("Can't load data file." + iOException + ", " + iOException.getMessage());
        }
    }

    private static void readExclusionList() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(dir + '/' + COMPOSITION_EXCLUSIONS), 5120);
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf(35);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if (string.length() == 0) continue;
            int n3 = string.indexOf(32);
            if (n3 < 0) {
                n3 = string.length();
            }
            int n4 = Integer.parseInt(string.substring(0, n3), 16);
            exclusionList.add(new Integer(n4));
        }
        bufferedReader.close();
    }

    private static void buildDecompositionTables() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(dir + '/' + UNICODE_DATA), 65536);
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            boolean bl2;
            int n2;
            int n3 = string.indexOf(35);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if (string.length() == 0) continue;
            int n4 = 0;
            int n5 = string.indexOf(59);
            try {
                n2 = Integer.parseInt(string.substring(n4, n5), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Bad hex value in line:\n" + string);
            }
            if (n2 == 192) {
                System.out.println("debug: " + string);
            }
            n5 = string.indexOf(59, n5 + 1);
            n5 = string.indexOf(59, n5 + 1);
            n4 = n5 + 1;
            int n6 = Integer.parseInt(string.substring(n4, n5 = string.indexOf(59, n4)));
            if (n6 != (n6 & 0xFF)) {
                System.err.println("Bad canonical class at: " + string);
            }
            canonicalClassKeys.add(new Integer(n2));
            canonicalClassValues.add(new Integer(n6));
            n5 = string.indexOf(59, n5 + 1);
            n4 = n5 + 1;
            if (n4 == (n5 = string.indexOf(59, n4))) continue;
            String string3 = string.substring(n4, n5);
            boolean bl3 = bl2 = string3.charAt(0) == '<';
            if (bl2) {
                compatibilityList.add(new Integer(n2));
            }
            if ((string2 = UnicodeDataGenerator.fromHex(string3)).length() < 1 || string2.length() > 2 && !bl2) {
                System.err.println("Bad decomp at: " + string);
            }
            decompositionKeys.add(new Integer(n2));
            decompositionValues.add(string2);
        }
        bufferedReader.close();
    }

    public static String fromHex(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(5);
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    int n2 = string.indexOf(32, i2);
                    if (n2 < 0) {
                        n2 = string.length();
                    }
                    try {
                        fastStringBuffer.append((char)Integer.parseInt(string.substring(i2, n2), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Bad hex value in " + string);
                    }
                    i2 = n2;
                    continue block7;
                }
                case '<': {
                    int n3 = string.indexOf(62, i2);
                    if (n3 > 0) {
                        i2 = n3;
                        continue block7;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Bad hex value in " + string);
                }
            }
        }
        return fastStringBuffer.toString();
    }

    public static String hex(char c2) {
        String string = Integer.toString(c2, 16).toUpperCase();
        return "0000".substring(string.length(), 4) + string;
    }

    public static String hex(String string, String string2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (i2 != 0) {
                fastStringBuffer.append(string2);
            }
            fastStringBuffer.append(UnicodeDataGenerator.hex(string.charAt(i2)));
        }
        return fastStringBuffer.toString();
    }

    private static void generateJava(PrintStream printStream) {
        printStream.println("package net.sf.saxon.codenorm;");
        printStream.println("");
        printStream.println("//This module was generated by running net.sf.saxon.codenorm.UnicodeDataGenerator");
        printStream.println("//*** DO NOT EDIT! ***");
        printStream.println("//The strange format of this file is carefully chosen to avoid breaking Java compiler limits");
        printStream.println("");
        printStream.println("public class UnicodeData {");
        printStream.println("public static final String[] canonicalClassKeys = {");
        UnicodeDataGenerator.printArray(printStream, canonicalClassKeys.iterator());
        printStream.println("};");
        printStream.println("public static final String[] canonicalClassValues = {");
        UnicodeDataGenerator.printArray(printStream, canonicalClassValues.iterator());
        printStream.println("};");
        printStream.println("public static final String[] decompositionKeys = {");
        UnicodeDataGenerator.printArray(printStream, decompositionKeys.iterator());
        printStream.println("};");
        printStream.println("public static final String[] decompositionValues = {");
        UnicodeDataGenerator.printStringArray(printStream, decompositionValues.iterator());
        printStream.println("};");
        printStream.println("public static final String[] exclusionList = {");
        UnicodeDataGenerator.printArray(printStream, exclusionList.iterator());
        printStream.println("};");
        printStream.println("public static final String[] compatibilityList = {");
        UnicodeDataGenerator.printArray(printStream, compatibilityList.iterator());
        printStream.println("};");
        printStream.println("}");
    }

    private static void printArray(PrintStream printStream, Iterator iterator) {
        int n2 = 0;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
        if (!iterator.hasNext()) {
            return;
        }
        fastStringBuffer.append('\"');
        while (true) {
            if (++n2 == 20) {
                n2 = 0;
                fastStringBuffer.append("\",");
                printStream.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
                fastStringBuffer.append('\"');
            }
            int n3 = (Integer)iterator.next();
            fastStringBuffer.append(Integer.toString(n3, 32));
            if (!iterator.hasNext()) break;
            fastStringBuffer.append(",");
        }
        fastStringBuffer.append("\"");
        printStream.println(fastStringBuffer.toString());
    }

    private static void printStringArray(PrintStream printStream, Iterator iterator) {
        int n2 = 0;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
        if (!iterator.hasNext()) {
            return;
        }
        while (true) {
            if (++n2 == 20) {
                n2 = 0;
                printStream.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
            }
            String string = (String)iterator.next();
            UnicodeDataGenerator.appendJavaString(string, fastStringBuffer);
            if (!iterator.hasNext()) break;
            fastStringBuffer.append(", ");
        }
        printStream.println(fastStringBuffer.toString());
    }

    private static void appendJavaString(String string, FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('\"');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                fastStringBuffer.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                fastStringBuffer.append("\\\"");
                continue;
            }
            if (c2 > ' ' && c2 < '\u007f') {
                fastStringBuffer.append(c2);
                continue;
            }
            fastStringBuffer.append("\\u");
            char c3 = "0123456789abcdef".charAt(c2 & 0xF);
            char c4 = "0123456789abcdef".charAt(c2 >> 4 & 0xF);
            char c5 = "0123456789abcdef".charAt(c2 >> 8 & 0xF);
            char c6 = "0123456789abcdef".charAt(c2 >> 12 & 0xF);
            fastStringBuffer.append(c6);
            fastStringBuffer.append(c5);
            fastStringBuffer.append(c4);
            fastStringBuffer.append(c3);
        }
        fastStringBuffer.append('\"');
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("Usage: java UnicodeDataGenerator dir UnicodeData.java");
            System.err.println("where dir is the directory containing the files UnicodeData.text and CompositionExclusions.txt from the Unicode character database");
        }
        dir = stringArray[0];
        UnicodeDataGenerator.build();
        PrintStream printStream = new PrintStream(new FileOutputStream(new File(stringArray[1])));
        UnicodeDataGenerator.generateJava(printStream);
    }

    static {
        UNICODE_DATA = "UnicodeData.txt";
        COMPOSITION_EXCLUSIONS = "CompositionExclusions.txt";
        canonicalClassKeys = new ArrayList(30000);
        canonicalClassValues = new ArrayList(30000);
        decompositionKeys = new ArrayList(6000);
        decompositionValues = new ArrayList(6000);
        exclusionList = new ArrayList(200);
        compatibilityList = new ArrayList(8000);
    }
}

