/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.runtime.model;

import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public class VDBArchiveSoftRef
implements VDBStream,
Serializable {
    private byte[] content = null;
    private File softFile = null;

    public VDBArchiveSoftRef(File softRefFile) {
        if (!softRefFile.exists()) {
            throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBArchiveSotRef.File_doesnt_exist", softRefFile.getAbsolutePath()));
        }
        this.softFile = softRefFile;
    }

    public VDBArchiveSoftRef(byte[] vdbArchive) {
        ArgCheck.isNotNull(vdbArchive);
        this.content = vdbArchive;
    }

    public File getFile() {
        return this.softFile;
    }

    public InputStream getInputStream() {
        this.loadFile();
        return new ByteArrayInputStream(this.content);
    }

    public byte[] toByteArray() {
        this.loadFile();
        return this.content;
    }

    private void loadFile() {
        if (this.content != null) {
            return;
        }
        FileUtil file = new FileUtil(this.softFile.getAbsolutePath());
        try {
            this.content = file.readBytesSafe();
        }
        catch (Exception err) {
            throw new MetaMatrixRuntimeException(err, VdbEditPlugin.Util.getString("VDBArchiveSotRef.Unable_to_reead_file", this.softFile.getAbsolutePath()));
        }
    }
}

