/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.runtime.model;

import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.runtime.model.URIResource;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BasicModelInfo
implements ModelInfo,
Serializable {
    private static final URIResource uriresource = new URIResource();
    private String name;
    private String uuid;
    private String version;
    private Date versionDate;
    private String versionedBy;
    private String description;
    private boolean isPhysical;
    private boolean requireConnBinding;
    private Set bindingNames = Collections.synchronizedSet(new HashSet());
    private boolean multiSourceBindingEnabled;
    private int modelType = 4;
    private String uri = null;
    private boolean isVisible;
    private Map ddlFileNamesToFiles = Collections.EMPTY_MAP;

    protected BasicModelInfo() {
    }

    public BasicModelInfo(ModelInfo model) {
        this(model.getName());
        this.setModelType(model.getModelType());
        this.setModelURI(model.getModelURI());
        this.setVersion(model.getVersion());
        this.setUuid(model.getUUID());
        this.setConnectorBindingNames(model.getConnectorBindingNames());
        this.setIsVisible(model.isVisible());
        this.enableMutliSourceBindings(model.isMultiSourceBindingEnabled());
        this.setDescription(model.getDescription());
        this.setVersionDate(model.getDateVersioned());
        this.setVersionedBy(model.getVersionedBy());
    }

    public BasicModelInfo(ModelReference modelRef) {
        String fullPath = modelRef.getModelLocation() == null ? "NoPath" : modelRef.getModelLocation();
        Path p2 = new Path(fullPath);
        String name = p2.lastSegment();
        IPath np = new Path(name);
        np = np.removeFileExtension();
        this.setName(((Object)np).toString());
        String v2 = modelRef.getVersion() == null ? "0" : modelRef.getVersion();
        this.setVersion(v2);
        this.setModelType(modelRef.getModelType().getValue());
        this.setModelURI(modelRef.getPrimaryMetamodelUri());
        this.setIsVisible(modelRef.isVisible());
        String uuid = modelRef.getUuid() == null ? "NoUUID" : modelRef.getUuid();
        this.setUuid(uuid);
        this.setVersionDate(new Date());
        this.setVersionedBy("");
    }

    public BasicModelInfo(String modelName) {
        this.name = modelName;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public int getModelType() {
        return this.modelType;
    }

    public String getModelTypeName() {
        return ModelType.get(this.modelType).getName();
    }

    public String getModelURI() {
        return this.uri;
    }

    public Date getDateVersioned() {
        return this.versionDate;
    }

    public String getVersionedBy() {
        return this.versionedBy;
    }

    public boolean isPhysical() {
        return this.isPhysical;
    }

    public boolean requiresConnectorBinding() {
        return this.requireConnBinding;
    }

    public List getConnectorBindingNames() {
        if (this.bindingNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList bindings = new ArrayList(this.bindingNames.size());
        bindings.addAll(this.bindingNames);
        return bindings;
    }

    public boolean supportsMultiSourceBindings() {
        switch (this.modelType) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionDate(Date date) {
        this.versionDate = date;
    }

    public void setVersionedBy(String versionedBy) {
        this.versionedBy = versionedBy;
    }

    public boolean isVisible() {
        if (this.uri == null) {
            return false;
        }
        return this.isVisible;
    }

    public boolean isMaterialization() {
        return this.modelType == 10;
    }

    public byte[] getDDLFileContentsGetBytes(String ddlFileName) {
        byte[] ddlFile = null;
        if (this.modelType == 10) {
            ddlFile = (byte[])this.ddlFileNamesToFiles.get(ddlFileName);
        }
        return ddlFile;
    }

    public InputStream getDDLFileContentsAsStream(String ddlFileName) {
        if (this.modelType == 10) {
            InputStream fileStream;
            byte[] ddlFile = (byte[])this.ddlFileNamesToFiles.get(ddlFileName);
            if (ddlFile == null) {
                return null;
            }
            try {
                fileStream = ByteArrayHelper.toInputStream(ddlFile);
            }
            catch (Exception err) {
                return null;
            }
            return fileStream;
        }
        return null;
    }

    public String[] getDDLFileNames() {
        if (this.modelType == 10) {
            Set keys = this.ddlFileNamesToFiles.keySet();
            String[] ddlFileNames = new String[keys.size()];
            Iterator fileNameItr = keys.iterator();
            int i2 = 0;
            while (fileNameItr.hasNext()) {
                String afileName;
                ddlFileNames[i2] = afileName = (String)fileNameItr.next();
                ++i2;
            }
            return ddlFileNames;
        }
        return new String[0];
    }

    public void setDDLFiles(Map ddlFileNamesToFiles) {
        this.ddlFileNamesToFiles = ddlFileNamesToFiles;
    }

    public void setIsVisible(boolean visibility) {
        this.isVisible = visibility;
    }

    public void setVisibility(short visibility) {
        if (visibility == 0) {
            this.setIsVisible(true);
        } else {
            this.setIsVisible(false);
        }
    }

    public short getVisibility() {
        if (this.isVisible()) {
            return 0;
        }
        return 2;
    }

    boolean isConnectorBindingUsed(String bindingName) {
        return this.bindingNames.contains(bindingName);
    }

    public void addConnectorBindingByName(String connectrBindingName) {
        if (this.bindingNames == null) {
            this.bindingNames = new HashSet();
        }
        this.bindingNames.add(connectrBindingName);
    }

    public void setConnectorBindingNames(List newbindingNames) {
        this.bindingNames.clear();
        this.bindingNames.addAll(newbindingNames);
    }

    public void removeConnectorBindingName(String bindingName) {
        this.bindingNames.remove(bindingName);
    }

    public void renameConnectorBinding(String exitingbindingName, String newbindingname) {
        boolean removed = this.bindingNames.remove(exitingbindingName);
        if (removed) {
            this.addConnectorBindingByName(newbindingname);
        }
    }

    public void setModelType(int type) {
        this.modelType = type;
        this.setTypeLogic();
    }

    public void setModelURI(String uri) {
        this.uri = uri;
        this.setTypeLogic();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    private void setTypeLogic() {
        if (this.modelType == 0 || this.modelType == 10) {
            this.setIsPhysical(true);
            if (this.uri != null && this.uri.trim().length() > 0) {
                if (uriresource.isPhysicalBindingAllowed(this.uri)) {
                    this.setRequireConnectorBinding(true);
                } else {
                    this.setRequireConnectorBinding(false);
                }
            } else {
                this.setRequireConnectorBinding(false);
            }
        } else {
            this.setIsPhysical(false);
            this.setRequireConnectorBinding(false);
        }
    }

    private void setRequireConnectorBinding(boolean requireConnBinding) {
        this.requireConnBinding = requireConnBinding;
    }

    private void setIsPhysical(boolean isPhysical) {
        this.isPhysical = isPhysical;
    }

    public void enableMutliSourceBindings(boolean isEnabled) {
        this.multiSourceBindingEnabled = isEnabled;
    }

    public boolean isMultiSourceBindingEnabled() {
        return this.multiSourceBindingEnabled;
    }

    public String toString() {
        StringBuffer sw = new StringBuffer();
        sw.append("ModelInfo: " + this.getName());
        sw.append("\n\tVersion: " + this.getVersion());
        sw.append("\n\tTypeCode: " + this.getModelType());
        sw.append("\n\tType: " + this.getModelTypeName());
        sw.append("\n\thasBindings: " + (this.getConnectorBindingNames().size() > 0));
        sw.append("\n\tIsVisible: " + this.isVisible());
        sw.append("\n\tIsPhysical: " + this.isPhysical());
        sw.append("\n\tIsMaterialization: " + this.isMaterialization());
        sw.append("\n\tURI: " + this.getModelURI());
        sw.append("\n\tRequiresBinding: " + this.requiresConnectorBinding());
        return sw.toString();
    }
}

