/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit.validation;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import com.metamatrix.internal.core.xml.vdb.VdbHeaderReader;
import com.metamatrix.internal.core.xml.vdb.VdbModelInfo;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.builder.ResourceValidator;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class VdbResourceValidator
implements ResourceValidator {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(class$com$metamatrix$vdb$internal$edit$validation$VdbResourceValidator == null ? (class$com$metamatrix$vdb$internal$edit$validation$VdbResourceValidator = VdbResourceValidator.class$("com.metamatrix.vdb.internal.edit.validation.VdbResourceValidator")) : class$com$metamatrix$vdb$internal$edit$validation$VdbResourceValidator);
    public static final int STALE_MODEL_CODE = 5001;
    public static final int NULL_MANIFEST_MODEL_CODE = 5002;
    public static final int VDB_ARCHIVE_ERROR_CODE = 5003;
    public static final int VDB_ARCHIVE_WARNING_CODE = 5004;
    public static final int VDB_ARCHIVE_INFO_CODE = 5005;
    public static final int DUP_UUID_CODE = 5006;
    private static final String DUP_UUID_MSG_ID = I18N_PREFIX + "duplicateUuidMessage";
    static /* synthetic */ Class class$com$metamatrix$vdb$internal$edit$validation$VdbResourceValidator;

    public boolean isValidatorForObject(Object obj) {
        IPath path;
        IResource iResource;
        return obj instanceof IResource ? ModelUtil.isVdbArchiveFile(iResource = (IResource)obj) : obj instanceof IPath && ModelUtil.isVdbArchiveFile(path = (IPath)obj);
    }

    public void validate(IProgressMonitor monitor, Object obj, ValidationContext context) throws ModelerCoreException {
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = VdbEditPlugin.Util.getString(I18N_PREFIX + "validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        context.clearResults();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            this.validate(iResource, context);
        } else if (obj instanceof IPath) {
            IPath path = (IPath)obj;
            IResource vdbResource = ModelerCore.getWorkspace().getRoot().findMember(path);
            if (vdbResource != null) {
                this.validate(vdbResource, context);
            }
        }
    }

    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    ValidationResult result = (ValidationResult)iter.next();
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    for (int probCnt = 0; probCnt < problems.length; ++probCnt) {
                        this.createProblemMarker(iResource, problems[probCnt]);
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    public boolean isValidatorForResource(IResource iResource) {
        return ModelUtil.isVdbArchiveFile(iResource);
    }

    public void validate(IProgressMonitor monitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        ArgCheck.isNotNull(iResource);
        if (!ModelUtil.isVdbArchiveFile(iResource)) {
            String msg = VdbEditPlugin.Util.getString(I18N_PREFIX + "VdbResource_validator_may_only_be_used_to_validate_VDB_Resources_1");
            throw new ModelerCoreException(msg);
        }
        context.clearResults();
        this.validate(iResource, context);
    }

    public void validationStarted(Collection resources, ValidationContext context) {
    }

    public void validationEnded(ValidationContext context) {
    }

    private void validate(IResource iResource, ValidationContext context) throws ModelerCoreException {
        ArgCheck.isNotNull(iResource);
        if (!ModelUtil.isVdbArchiveFile(iResource)) {
            String msg = VdbEditPlugin.Util.getString(I18N_PREFIX + "VdbResource_validator_may_only_be_used_to_validate_VDB_Resources_1");
            throw new ModelerCoreException(msg);
        }
        IPath vdbPath = iResource.getFullPath();
        try {
            File vdbFile = iResource.getLocation().toFile();
            if (vdbFile == null || !vdbFile.exists()) {
                return;
            }
            VdbHeader header = VdbHeaderReader.readHeader(vdbFile);
            if (header == null) {
                String msg = VdbEditPlugin.Util.getString(I18N_PREFIX + "vdbWithNoHeader", vdbPath);
                this.addProblem(iResource, 5002, 2, msg, context);
                return;
            }
            VdbModelInfo[] infos = header.getModelInfos();
            for (int i2 = 0; i2 < infos.length; ++i2) {
                File modelFile;
                long workspaceModelChecksum;
                VdbModelInfo modelInfo = infos[i2];
                long vdbModelCheckSum = modelInfo.getCheckSum();
                IResource modelResource = null;
                String location = modelInfo.getLocation();
                String path = modelInfo.getPath();
                if (!StringUtil.isEmpty(path)) {
                    modelResource = ModelerCore.getWorkspace().getRoot().findMember(path);
                } else if (!StringUtil.isEmpty(location) && !location.startsWith("http")) {
                    modelResource = ModelerCore.getWorkspace().getRoot().findMember(location);
                }
                if (modelResource == null || vdbModelCheckSum == (workspaceModelChecksum = FileUtils.getCheckSum(modelFile = modelResource.getLocation().toFile()))) continue;
                Object[] params = new Object[]{modelInfo.getName()};
                String msg = VdbEditPlugin.Util.getString(I18N_PREFIX + "staleModelWarningMsg", params);
                this.addProblem(iResource, 5001, 2, msg, context);
            }
            String uuid = header.getUUID();
            if (context.containsUuid(uuid)) {
                String msg = VdbEditPlugin.Util.getString(DUP_UUID_MSG_ID, vdbPath.lastSegment());
                this.addProblem(iResource, 5006, 4, msg, context);
            } else {
                context.addUuidToContext(uuid);
            }
            String problemMsg = null;
            String severity = header.getSeverity();
            if (severity.equals("ERROR")) {
                problemMsg = VdbEditPlugin.Util.getString("VdbResourceValidator.0", header.getName());
                this.addProblem(iResource, 5003, 4, problemMsg, context);
            } else if (severity.equals("WARNING")) {
                problemMsg = VdbEditPlugin.Util.getString("VdbResourceValidator.1", header.getName());
                this.addProblem(iResource, 5004, 2, problemMsg, context);
            } else if (severity.equals("INFO")) {
                problemMsg = VdbEditPlugin.Util.getString("VdbResourceValidator.2", header.getName());
                this.addProblem(iResource, 5005, 1, problemMsg, context);
            }
        }
        catch (Exception e2) {
            throw new ModelerCoreException((Throwable)e2, VdbEditPlugin.Util.getString("VdbResourceValidator.Unexpected_error_validating_VDB_1"));
        }
    }

    private void addProblem(Object object, int code, int severity, String msg, ValidationContext context) {
        ValidationProblemImpl problem = new ValidationProblemImpl(code, severity, msg);
        ValidationResultImpl result = new ValidationResultImpl(object);
        result.addProblem(problem);
        context.addResult(result);
    }

    private void createProblemMarker(IResource resource, ValidationProblem problem) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("message", problem.getMessage());
        marker.setAttribute("com.metamatrix.modeler.core.markerURI", ((Object)resource.getFullPath()).toString());
        if (problem.getCode() == 5001) {
            String text = VdbEditPlugin.Util.getString("VdbResourceValidator.out_of_synch");
            marker.setAttribute("com.metamatrix.modeler.core.problemDecoratorText", text);
        }
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

