/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.vdb.edit.VdbArtifactGenerator;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.manifest.WsdlOptions;
import com.metamatrix.vdb.internal.edit.InternalVdbGenerationContext;
import com.metamatrix.vdb.internal.edit.WsdlGenerationOptionsHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;

public class WsdlArtifactGenerator
implements VdbArtifactGenerator {
    public static final String GENERATED_WSDL_NAME = "MetaMatrixDataServices";
    public static final String GENERATED_WSDL_FILENAME = "MetaMatrixDataServices.wsdl";
    public static final String WSDL_DEFAULT_TARGET_NAMESPACE_URI_PREFIX = "http://com.metamatrix/";
    public static final String WSDL_DEFAULT_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final int CREATE_WSDL_GENERATOR_ERROR_CODE = 100601;
    public static final int WRITE_WSDL_FILE_ERROR_CODE = 100602;
    public static final int GENERATE_WSDL_FILE_ERROR_CODE = 100603;
    public static final int CLOSE_STREAM_ERROR_CODE = 100604;
    public static final int WSDL_FILE_EXISTS_ERROR_CODE = 100605;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(VdbGenerationContext theContext) {
        String pathInVdb;
        boolean success;
        File wsdlFile;
        InternalVdbGenerationContext context;
        block35: {
            OutputStream wsdlStream;
            IStatus genStatus;
            block34: {
                ArgCheck.isNotNull(theContext);
                if (!(theContext instanceof InternalVdbGenerationContext)) {
                    String msg = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.InternalVdbGenerationContext_required");
                    throw new IllegalArgumentException(msg);
                }
                context = (InternalVdbGenerationContext)theContext;
                String displayMessage = "Generating WSDL file ...";
                context.setProgressMessage(displayMessage);
                ArrayList<Resource> eResources = new ArrayList<Resource>(Arrays.asList(context.getModels()));
                WsdlOptions wsdlOptions = (WsdlOptions)context.getData("WsdlGenerationOptions");
                if (wsdlOptions == null) {
                    wsdlOptions = ManifestFactory.eINSTANCE.createWsdlOptions();
                    wsdlOptions.setTargetNamespaceUri(WSDL_DEFAULT_TARGET_NAMESPACE_URI_PREFIX + this.getVirtualDatabase(context).getName());
                    wsdlOptions.setDefaultNamespaceUri(WSDL_DEFAULT_NAMESPACE_URI);
                    this.getVirtualDatabase(context).setWsdlOptions(wsdlOptions);
                }
                HashMap<Resource, IPath> eResourceToPath = new HashMap<Resource, IPath>(eResources.size());
                Iterator i2 = eResources.iterator();
                while (i2.hasNext()) {
                    Resource model = (Resource)i2.next();
                    String path = context.getModelHelper().getPath(model);
                    if (StringUtil.isEmpty(path)) continue;
                    eResourceToPath.put(model, this.createNormalizedPath(path));
                }
                WsdlGenerationOptionsHelper helper = null;
                try {
                    helper = new WsdlGenerationOptionsHelper(eResources, wsdlOptions, eResourceToPath);
                }
                catch (Throwable e2) {
                    String msg = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_creating_wsdl_generator");
                    context.addErrorMessage(msg, 100601, e2);
                    return;
                }
                wsdlFile = null;
                if (!helper.canWsdlBeGenerated()) break block35;
                genStatus = null;
                wsdlStream = null;
                wsdlFile = new File(context.getTemporaryDirectory(), GENERATED_WSDL_FILENAME);
                wsdlStream = new FileOutputStream(wsdlFile);
                wsdlStream = new BufferedOutputStream(wsdlStream);
                genStatus = helper.generateWsdl(new NullProgressMonitor(), wsdlStream);
                Object var14_14 = null;
                if (wsdlStream == null) break block34;
                try {
                    wsdlStream.close();
                }
                catch (IOException e3) {
                    String msg2 = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_closing_stream", GENERATED_WSDL_FILENAME);
                    context.addErrorMessage(msg2, 100604, e3);
                }
            }
            if (genStatus == null || genStatus.isOK()) break block35;
            if (genStatus instanceof MultiStatus) {
                IStatus[] children = ((MultiStatus)genStatus).getChildren();
                for (int i3 = 0; i3 < children.length; ++i3) {
                    this.addMessage(context, children[i3], 100603);
                }
            } else {
                this.addMessage(context, genStatus, 100603);
                {
                    break block35;
                    catch (IOException e4) {
                        String msg = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_writing_wsdl_to_scratch", GENERATED_WSDL_FILENAME);
                        context.addErrorMessage(msg, 100602, e4);
                        Object var14_15 = null;
                        if (wsdlStream != null) {
                            try {
                                wsdlStream.close();
                            }
                            catch (IOException e3) {
                                String msg2 = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_closing_stream", GENERATED_WSDL_FILENAME);
                                context.addErrorMessage(msg2, 100604, e3);
                            }
                        }
                        if (genStatus != null && !genStatus.isOK()) {
                            if (genStatus instanceof MultiStatus) {
                                IStatus[] children = ((MultiStatus)genStatus).getChildren();
                                for (int i3 = 0; i3 < children.length; ++i3) {
                                    this.addMessage(context, children[i3], 100603);
                                }
                            } else {
                                this.addMessage(context, genStatus, 100603);
                            }
                        }
                        break block35;
                    }
                    catch (Throwable e5) {
                        String msg = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_generating_wsdl", GENERATED_WSDL_FILENAME);
                        context.addErrorMessage(msg, 100603, e5);
                        Object var14_16 = null;
                        if (wsdlStream != null) {
                            try {
                                wsdlStream.close();
                            }
                            catch (IOException e3) {
                                String msg2 = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_closing_stream", GENERATED_WSDL_FILENAME);
                                context.addErrorMessage(msg2, 100604, e3);
                            }
                        }
                        if (genStatus != null && !genStatus.isOK()) {
                            if (genStatus instanceof MultiStatus) {
                                IStatus[] children = ((MultiStatus)genStatus).getChildren();
                                for (int i3 = 0; i3 < children.length; ++i3) {
                                    this.addMessage(context, children[i3], 100603);
                                }
                            } else {
                                this.addMessage(context, genStatus, 100603);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (wsdlStream != null) {
                        try {
                            wsdlStream.close();
                        }
                        catch (IOException e3) {
                            String msg2 = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_closing_stream", GENERATED_WSDL_FILENAME);
                            context.addErrorMessage(msg2, 100604, e3);
                        }
                    }
                    if (genStatus != null && !genStatus.isOK()) {
                        if (genStatus instanceof MultiStatus) {
                            IStatus[] children = ((MultiStatus)genStatus).getChildren();
                            for (int i3 = 0; i3 < children.length; ++i3) {
                                this.addMessage(context, children[i3], 100603);
                            }
                        } else {
                            this.addMessage(context, genStatus, 100603);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (wsdlFile != null && !(success = context.addGeneratedArtifact(pathInVdb = wsdlFile.getName(), wsdlFile))) {
            String msg = VdbEditPlugin.Util.getString("WsdlArtifactGenerator.Error_file_already_exists", pathInVdb);
            context.addWarningMessage(msg, 100605);
        }
    }

    protected VirtualDatabase getVirtualDatabase(InternalVdbGenerationContext context) {
        ArgCheck.isNotNull(context);
        return context.getVdbContext().getVirtualDatabase();
    }

    protected IPath createNormalizedPath(String pathInArchive) {
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        return new Path(pathInArchive).makeAbsolute();
    }

    protected void addMessage(VdbGenerationContext context, IStatus status, int code) {
        if (context != null && status != null) {
            switch (status.getSeverity()) {
                case 1: {
                    context.addInfoMessage(status.getMessage(), code);
                    break;
                }
                case 2: {
                    context.addWarningMessage(status.getMessage(), code);
                    break;
                }
                case 4: {
                    context.addErrorMessage(status.getMessage(), code, null);
                    break;
                }
            }
        }
    }
}

