/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.TempDirectory;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class VdbUriConverter
extends URIConverterImpl {
    private static final String SEGMENT_SEPARATOR = "/";
    private IPath tempDirPath = null;

    public VdbUriConverter(TempDirectory theTempDirectory) {
        this.tempDirPath = new Path(theTempDirectory.getPath());
    }

    public URI normalize(URI uri) {
        String fragment = uri.fragment();
        URI result = fragment == null ? this.getInternalURIMap().getURI(uri) : this.getInternalURIMap().getURI(uri.trimFragment()).appendFragment(fragment);
        String scheme = result.scheme();
        if (scheme == null) {
            if (result.hasAbsolutePath()) {
                String uriString = URI.decode(uri.toString());
                if (uriString.startsWith(SEGMENT_SEPARATOR)) {
                    IPath tempDirFilePath = this.tempDirPath.append(new Path(uriString));
                    result = URI.createFileURI(((Object)tempDirFilePath).toString());
                } else {
                    result = URI.createURI("file:" + result);
                }
            } else {
                result = URI.createFileURI(new File(result.trimFragment().toString()).getAbsolutePath());
                if (fragment != null) {
                    result = result.appendFragment(fragment);
                }
            }
        }
        if (result.equals(uri)) {
            return uri;
        }
        return this.normalize(result);
    }
}

