/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.edit.manifest.ProblemMarker;
import com.metamatrix.vdb.edit.manifest.Severity;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class VdbGenerationModelObjectHelper
implements VdbGenerationContext.ModelObjectHelper {
    final Map problemsByObjectId;

    public VdbGenerationModelObjectHelper(Map problemsByObjectId) {
        ArgCheck.isNotNull(problemsByObjectId);
        this.problemsByObjectId = problemsByObjectId;
    }

    public String getUuid(EObject objectInModel) {
        ArgCheck.isNotNull(objectInModel);
        ObjectID id = objectInModel.getObjectId();
        return ((Object)id).toString();
    }

    public String getDescription(EObject objectInModel) {
        ArgCheck.isNotNull(objectInModel);
        Annotation existingAnnotation = this.getExistingAnnotation(objectInModel);
        if (existingAnnotation != null) {
            return existingAnnotation.getDescription();
        }
        return null;
    }

    public boolean hasErrors(EObject objectInModel) {
        if (objectInModel != null && this.problemsByObjectId.containsKey(objectInModel.getObjectId())) {
            Collection problems = (Collection)this.problemsByObjectId.get(objectInModel.getObjectId());
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                ProblemMarker marker = (ProblemMarker)iter.next();
                if (marker.getSeverity() != Severity.ERROR_LITERAL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasWarnings(EObject objectInModel) {
        if (objectInModel != null && this.problemsByObjectId.containsKey(objectInModel.getObjectId())) {
            Collection problems = (Collection)this.problemsByObjectId.get(objectInModel.getObjectId());
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                ProblemMarker marker = (ProblemMarker)iter.next();
                if (marker.getSeverity() != Severity.WARNING_LITERAL) continue;
                return true;
            }
        }
        return false;
    }

    public Properties getProperties(EObject objectInModel) {
        ArgCheck.isNotNull(objectInModel);
        Properties properties = new Properties();
        Annotation existingAnnotation = this.getExistingAnnotation(objectInModel);
        if (existingAnnotation != null) {
            EMap props = existingAnnotation.getTags();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                properties.put(key, value);
            }
        }
        return properties;
    }

    protected Annotation getExistingAnnotation(EObject objectInModel) {
        EmfResource emfResource;
        ModelContents contents;
        Resource resource = objectInModel.eResource();
        if (resource instanceof EmfResource && (contents = (emfResource = (EmfResource)resource).getModelContents()) != null) {
            return contents.getAnnotation(objectInModel);
        }
        return null;
    }
}

