/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.index.IIndexer;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexingContext;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.vdb.edit.VdbArtifactGenerator;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.internal.edit.InternalVdbGenerationContext;
import com.metamatrix.vdb.internal.edit.VdbDocumentImpl;
import com.metamatrix.vdb.internal.edit.VdbIndexer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class RuntimeIndexArtifactGenerator
implements VdbArtifactGenerator {
    public static final String PATH_OF_INDEXES_IN_ARCHIVE = "runtime-inf/";
    public static final int GENERATE_FILE_NAMES_ERROR_CODE = 100501;
    public static final int GENERATE_INDEXER_CONTEXT_ERROR_CODE = 100502;
    public static final int GENERATE_INDEX_FILE_ERROR_CODE = 100503;
    public static final int INDEX_FILE_EXISTS_ERROR_CODE = 100504;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(VdbGenerationContext theContext) {
        File indexFile;
        ArgCheck.isNotNull(theContext);
        if (!(theContext instanceof InternalVdbGenerationContext)) {
            String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.InternalVdbGenerationContext_required");
            throw new IllegalArgumentException(msg);
        }
        InternalVdbGenerationContext context = (InternalVdbGenerationContext)theContext;
        String displayMessage = "Generating runtime indexes ...";
        context.setProgressMessage(displayMessage);
        File parentFolder = new File(context.getTemporaryDirectory(), PATH_OF_INDEXES_IN_ARCHIVE);
        if (!parentFolder.exists()) {
            parentFolder.mkdir();
        }
        String[] indexNames = IndexConstants.INDEX_NAME.INDEX_NAMES;
        File[] indexFilesArray = new File[indexNames.length];
        try {
            for (int i2 = 0; i2 < indexNames.length; ++i2) {
                String indexName = indexNames[i2];
                indexFilesArray[i2] = new File(parentFolder, indexName);
            }
        }
        catch (Throwable e2) {
            String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_generating_index_file_names");
            context.addErrorMessage(msg, 100501, e2);
            return;
        }
        Resource[] eResources = context.getModels();
        ArrayList<Resource> resourcesToIndex = new ArrayList<Resource>(Arrays.asList(eResources));
        resourcesToIndex.add(context.getVdbContext().getManifestResource());
        this.addGlobalResourcesToList(context, resourcesToIndex);
        Collections.sort(resourcesToIndex, new ResourceNameComparator());
        IndexingContext indexingContext = null;
        try {
            indexingContext = this.createIndexingContext(context, resourcesToIndex);
        }
        catch (Throwable e3) {
            String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_creating_indexing_context");
            context.addErrorMessage(msg, 100502, e3);
            return;
        }
        HashMap<URI, String> pathsByResourceUri = new HashMap<URI, String>();
        Iterator i3 = resourcesToIndex.iterator();
        while (i3.hasNext()) {
            Resource model = (Resource)i3.next();
            String path = context.getModelHelper().getPath(model);
            if (StringUtil.isEmpty(path)) continue;
            pathsByResourceUri.put(model.getURI(), ((Object)this.createNormalizedPath(path)).toString());
        }
        VdbIndexer indexer = null;
        try {
            Object var17_27;
            try {
                indexer = indexingContext != null ? new VdbIndexer(indexingContext) : new VdbIndexer();
                for (int i4 = 0; i4 < indexFilesArray.length; ++i4) {
                    indexFile = indexFilesArray[i4];
                    displayMessage = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Generating_runtime_indexes", indexFile.getName());
                    context.setProgressMessage(displayMessage);
                    try {
                        this.produceIndex(indexer, resourcesToIndex, indexFile, pathsByResourceUri);
                        continue;
                    }
                    catch (Throwable e4) {
                        String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_generating_runtime_index_file", indexFile.getName());
                        context.addErrorMessage(msg, 100503, e4);
                    }
                }
                var17_27 = null;
                if (indexingContext != null) {
                    indexingContext.clearState();
                }
                resourcesToIndex.clear();
                indexer = null;
            }
            catch (Throwable e5) {
                String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_generating_runtime_index_files");
                context.addErrorMessage(msg, 100503, e5);
                var17_27 = null;
                if (indexingContext != null) {
                    indexingContext.clearState();
                }
                resourcesToIndex.clear();
                indexer = null;
            }
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            if (indexingContext != null) {
                indexingContext.clearState();
            }
            resourcesToIndex.clear();
            indexer = null;
            throw throwable;
        }
        for (int i5 = 0; i5 < indexFilesArray.length; ++i5) {
            indexFile = indexFilesArray[i5];
            String pathInVdb = PATH_OF_INDEXES_IN_ARCHIVE + indexFile.getName();
            displayMessage = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_adding_runtime_index_file_to_generation_context", indexFile.getName());
            context.setProgressMessage(displayMessage);
            boolean success = context.addGeneratedArtifact(pathInVdb, indexFile);
            if (success) continue;
            String msg = VdbEditPlugin.Util.getString("RuntimeIndexArtifactGenerator.Error_artifact_already_exists", pathInVdb);
            context.addWarningMessage(msg, 100504);
        }
    }

    protected IndexingContext createIndexingContext(InternalVdbGenerationContext context, List eResources) {
        IndexingContext indexingContext = new IndexingContext();
        ArrayList<Resource> resourcesInScope = new ArrayList<Resource>(eResources);
        Resource[] systemVdbResources = ModelerCore.getSystemVdbResources();
        ArrayList<ObjectID> systemUuids = new ArrayList<ObjectID>(systemVdbResources.length);
        for (int i2 = 0; i2 < systemVdbResources.length; ++i2) {
            ObjectID uuid = ((EmfResource)systemVdbResources[i2]).getUuid();
            if (uuid == null) continue;
            systemUuids.add(uuid);
        }
        Iterator i3 = eResources.iterator();
        while (i3.hasNext()) {
            ObjectID uuid;
            Resource r2 = (Resource)i3.next();
            if (!(r2 instanceof EmfResource) || (uuid = ((EmfResource)r2).getUuid()) == null || !systemUuids.contains(uuid) || resourcesInScope.contains(r2)) continue;
            resourcesInScope.add(r2);
        }
        indexingContext.setResourcesInContext(resourcesInScope);
        Map virtToPhysMappings = (Map)context.getData("MaterializedViewVirtToPhysMappings");
        if (virtToPhysMappings != null && !virtToPhysMappings.isEmpty()) {
            Iterator i4 = virtToPhysMappings.entrySet().iterator();
            while (i4.hasNext()) {
                Map.Entry entry = i4.next();
                EObject virtualTable = (EObject)entry.getKey();
                Collection physicalTables = (Collection)entry.getValue();
                indexingContext.addMaterializedTables(virtualTable, physicalTables);
            }
        }
        return indexingContext;
    }

    protected void produceIndex(IIndexer indexer, List eResources, File indexFile, Map pathsByResourceUri) throws IOException {
        Index runtimeIndex = null;
        runtimeIndex = IndexUtil.indexFileExists(indexFile.getAbsolutePath()) ? new Index(indexFile.getAbsolutePath(), true) : new Index(indexFile.getAbsolutePath(), false);
        VdbDocumentImpl document = new VdbDocumentImpl(indexFile.getName(), eResources, pathsByResourceUri);
        runtimeIndex.add(document, indexer);
        runtimeIndex.save();
    }

    protected IPath createNormalizedPath(String pathInArchive) {
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotZeroLength(pathInArchive);
        return new Path(pathInArchive).makeAbsolute();
    }

    protected void addGlobalResourcesToList(InternalVdbGenerationContext context, List eResources) {
        Iterator i2 = eResources.iterator();
        while (i2.hasNext()) {
            Resource r2 = (Resource)i2.next();
            if (!"builtInDataTypes.xsd".equals(r2.getURI().lastSegment())) continue;
            return;
        }
        URI uri = URI.createURI("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        Resource mmTypes = context.getResourceSet().getResource(uri, true);
        if (mmTypes != null && !eResources.contains(mmTypes)) {
            eResources.add(mmTypes);
        }
    }

    private static class ResourceNameComparator
    implements Comparator {
        private ResourceNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            Resource r1 = (Resource)obj1;
            Resource r2 = (Resource)obj2;
            String value1 = r1.getURI().lastSegment();
            String value2 = r2.getURI().lastSegment();
            return value1.compareToIgnoreCase(value2);
        }
    }
}

