/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.materialization;

import com.metamatrix.core.util.StringUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DatabaseDialect
implements Serializable {
    private static final int NUMBER_OF_TYPES = 6;
    private static final Map DATABASE_DIALECT_MAP = new HashMap(6);
    private static final List DATABASE_DIALECTS = new ArrayList(6);
    private static final String ORACLE_TYPE = "Oracle";
    private static final String DB2_TYPE = "DB2";
    private static final String SQL_SERVER_TYPE = "SqlServer";
    private static final String SQL_SERVER_TYPE2 = "sql_server";
    private static final String METAMATRIX_TYPE = "MetaMatrix";
    private static final String CONNECTION_PROPS_TYPE = "ConnectionProps";
    private static final String ORACLE_DRIVER = "com.metamatrix.jdbc.oracle.OracleDriver";
    private static final String DB2_DRIVER = "com.metamatrix.jdbc.db2.DB2Driver";
    private static final String SQLSERVER_DRIVER = "com.metamatrix.jdbc.sqlserver.SQLServerDriver";
    private static final String METAMATRIX_DRIVER = "com.metamatrix.jdbc.MMDriver";
    public static final DatabaseDialect ORACLE = DatabaseDialect.newDatabaseDialect("Oracle", "com.metamatrix.jdbc.oracle.OracleDriver");
    public static final DatabaseDialect DB2 = DatabaseDialect.newDatabaseDialect("DB2", "com.metamatrix.jdbc.db2.DB2Driver");
    public static final DatabaseDialect SQL_SERVER = DatabaseDialect.newDatabaseDialect("SqlServer", "com.metamatrix.jdbc.sqlserver.SQLServerDriver");
    public static final DatabaseDialect METAMATRIX = new DatabaseDialect("MetaMatrix", "com.metamatrix.jdbc.MMDriver");
    public static final DatabaseDialect CONNECTION_PROPS = new DatabaseDialect("ConnectionProps");
    private String type;
    private String driverClassname;

    public String getType() {
        return this.type;
    }

    public String getDriverClassname() {
        return this.driverClassname;
    }

    public static Collection getAllDialects() {
        return DATABASE_DIALECTS;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatabaseDialect)) {
            return false;
        }
        return ((DatabaseDialect)obj).type == this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type;
    }

    private DatabaseDialect(String type) {
        this(type, null);
    }

    private DatabaseDialect(String type, String driver) {
        this.type = type;
        this.driverClassname = driver;
    }

    private static DatabaseDialect newDatabaseDialect(String type, String driver) {
        DatabaseDialect result = new DatabaseDialect(type, driver);
        DATABASE_DIALECT_MAP.put(type.toLowerCase(), result);
        DATABASE_DIALECTS.add(result);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        DatabaseDialect aType = (DatabaseDialect)DATABASE_DIALECT_MAP.get(this.type.toLowerCase());
        if (aType != null) {
            return aType;
        }
        return DatabaseDialect.newDatabaseDialect(this.type, this.driverClassname);
    }

    public static DatabaseDialect getDatabaseDialect(String type) {
        if (type.equalsIgnoreCase("mmx")) {
            type = METAMATRIX_TYPE;
        }
        return (DatabaseDialect)DATABASE_DIALECT_MAP.get(type.toLowerCase());
    }

    public static DatabaseDialect getDatabaseDialectByDDLName(String ddlName) {
        if (StringUtil.indexOfIgnoreCase(ddlName, ORACLE_TYPE) != -1) {
            return ORACLE;
        }
        if (StringUtil.indexOfIgnoreCase(ddlName, DB2_TYPE) != -1) {
            return DB2;
        }
        if (StringUtil.indexOfIgnoreCase(ddlName, SQL_SERVER_TYPE) != -1 || StringUtil.indexOfIgnoreCase(ddlName, SQL_SERVER_TYPE2) != -1) {
            return SQL_SERVER;
        }
        return METAMATRIX;
    }
}

