/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ICache;
import com.metamatrix.core.util.LRUCache;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.TableRecord;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadata;
import com.metamatrix.query.b.a.c;
import com.metamatrix.query.b.b.b;
import com.metamatrix.query.m.a;
import com.metamatrix.query.m.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TransformationMetadataFacade
implements e {
    public static final int DEFAULT_SPACELIMIT = 4000;
    public static final int DEFAULT_SPACELIMIT_PARTIAL_NAME_CACHE = 100;
    private final TransformationMetadata metadata;
    private final ICache nameToIdCache;
    private final ICache idToRecordCache;
    private final ICache partialNameToFullNameCache;
    private final Object lock1 = new Object();
    private final Object lock2 = new Object();
    private final Object lock3 = new Object();
    private final Object lock4 = new Object();
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metadata$runtime$TableRecord;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metadata$runtime$ColumnRecord;

    TransformationMetadataFacade(TransformationMetadata delegate) {
        this(delegate, 4000);
    }

    TransformationMetadataFacade(TransformationMetadata delegate, int cacheSize) {
        ArgCheck.isNotNull(delegate);
        this.metadata = delegate;
        this.nameToIdCache = new LRUCache(cacheSize);
        this.idToRecordCache = new LRUCache(cacheSize);
        this.partialNameToFullNameCache = new LRUCache(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementID(String elementName) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record = this.getRecordByName(elementName, 'G');
        if (record == null) {
            Object object = this.lock1;
            synchronized (object) {
                record = this.getRecordByName(elementName, 'G');
                if (record == null && (record = (MetadataRecord)this.metadata.getElementID(elementName)) != null) {
                    this.updateNameToIdCache(elementName, 'G', record.getUUID());
                    this.updateIdToRecordCache(record.getUUID(), record);
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGroupID(String groupName) throws MetaMatrixComponentException, QueryMetadataException {
        MetadataRecord record = this.getRecordByName(groupName, 'B');
        if (record == null) {
            Object object = this.lock2;
            synchronized (object) {
                record = this.getRecordByName(groupName, 'B');
                if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(groupName)) != null) {
                    this.updateNameToIdCache(groupName, 'B', record.getUUID());
                    this.updateIdToRecordCache(record.getUUID(), record);
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getGroupsForPartialName(String partialGroupName) throws MetaMatrixComponentException, QueryMetadataException {
        String fullName = this.getFullNameByPartialName(partialGroupName, 'B');
        if (fullName == null) {
            ICache iCache = this.partialNameToFullNameCache;
            synchronized (iCache) {
                fullName = this.getFullNameByPartialName(partialGroupName, 'B');
                if (fullName == null) {
                    Collection partialNameRecords = this.metadata.getGroupsForPartialName(partialGroupName);
                    if (partialNameRecords != null && partialNameRecords.size() == 1) {
                        this.updatePartialNameToFullName(partialGroupName, (String)partialNameRecords.iterator().next(), 'B');
                    }
                    return partialNameRecords;
                }
            }
        }
        ArrayList<String> partialNameRecords = new ArrayList<String>(1);
        partialNameRecords.add(fullName);
        return partialNameRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getModelID(Object groupOrElementID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, groupOrElementID);
        MetadataRecord record = (MetadataRecord)groupOrElementID;
        Object modelRecord = record.getPropertyValue("modelForRecord");
        if (modelRecord == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                modelRecord = record.getPropertyValue("modelForRecord");
                if (modelRecord == null) {
                    modelRecord = this.metadata.getModelID(groupOrElementID);
                    record.setPropertyValue("modelForRecord", modelRecord);
                }
            }
        }
        return modelRecord;
    }

    public String getFullName(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getFullName(metadataID);
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotZeroLength(fullGroupName);
        ArgCheck.isNotZeroLength(shortElementName);
        if (SqlConverter.isStringifiedUUID(shortElementName)) {
            return SqlConverter.stripPrefixFromUUID(shortElementName);
        }
        if (SqlConverter.isStringifiedUUID(fullGroupName)) {
            MetadataRecord group = (MetadataRecord)this.getGroupID(fullGroupName);
            if (group == null) {
                throw new QueryMetadataException(TransformationPlugin.Util.getString("TransformationMetadata.Unable_to_determine_fullname_for_element__1") + shortElementName);
            }
            String groupName = group.getFullName();
            return groupName + '.' + shortElementName;
        }
        return fullGroupName + '.' + shortElementName;
    }

    public String getShortElementName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getShortElementName(fullElementName);
    }

    public String getGroupName(String fullElementName) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isNotZeroLength(fullElementName);
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(0, index);
        }
        if (SqlConverter.isStringifiedUUID(fullElementName)) {
            String newFullElementName = SqlConverter.stripPrefixFromUUID(fullElementName);
            MetadataRecord record = this.getRecordByID(newFullElementName);
            if (record == null) {
                record = (MetadataRecord)this.metadata.getElementID(newFullElementName);
                this.updateIdToRecordCache(newFullElementName, record);
            }
            return record.getParentUUID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInGroupID(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List elementIDs = (List)record.getPropertyValue("elementsInGroup");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInGroup");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInGroupID(groupID)) != null) {
                    record.setPropertyValue("elementsInGroup", elementIDs);
                    Iterator elemntIter = elementIDs.iterator();
                    while (elemntIter.hasNext()) {
                        MetadataRecord columnRecord = (MetadataRecord)elemntIter.next();
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGroupIDForElementID(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$ColumnRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$ColumnRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.ColumnRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$ColumnRecord, elementID);
        ColumnRecord columnRecord = (ColumnRecord)elementID;
        String tableUUID = columnRecord.getParentUUID();
        MetadataRecord record = this.getRecordByID(tableUUID);
        if (record == null) {
            Object object = this.lock3;
            synchronized (object) {
                record = this.getRecordByID(tableUUID);
                if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(tableUUID)) != null) {
                    this.updateNameToIdCache(record.getFullName(), record.getRecordType(), record.getUUID());
                    this.updateIdToRecordCache(record.getUUID(), record);
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public a getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws MetaMatrixComponentException, QueryMetadataException {
        a procInfo = null;
        MetadataRecord record = this.getRecordByName(fullyQualifiedProcedureName, 'E');
        if (record == null) {
            Object object = this.lock4;
            synchronized (object) {
                record = this.getRecordByName(fullyQualifiedProcedureName, 'E');
                if (record == null && (procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName)) != null) {
                    record = (MetadataRecord)procInfo.a();
                    record.setPropertyValue("storedProcInfoForRecord", procInfo);
                    this.updateNameToIdCache(fullyQualifiedProcedureName, 'E', record.getUUID());
                    this.updateIdToRecordCache(record.getUUID(), record);
                }
            }
        }
        if (procInfo == null && record != null && (procInfo = (a)record.getPropertyValue("storedProcInfoForRecord")) == null) {
            procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
            record.setPropertyValue("storedProcInfoForRecord", procInfo);
        }
        return procInfo;
    }

    public String getElementType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementType(elementID);
    }

    public Object getDefaultValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getDefaultValue(elementID);
    }

    public Object getMaximumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaximumValue(elementID);
    }

    public Object getMinimumValue(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMinimumValue(elementID);
    }

    public int getPosition(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getPosition(elementID);
    }

    public int getPrecision(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getPrecision(elementID);
    }

    public int getRadix(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getRadix(elementID);
    }

    public int getScale(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getScale(elementID);
    }

    public int getDistinctValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getDistinctValues(elementID);
    }

    public int getNullValues(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNullValues(elementID);
    }

    public boolean isVirtualGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isVirtualGroup(groupID);
    }

    public boolean hasMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.hasMaterialization(groupID);
    }

    public Object getMaterialization(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaterialization(groupID);
    }

    public Object getMaterializationStage(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaterializationStage(groupID);
    }

    public boolean isVirtualModel(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isVirtualModel(modelID);
    }

    public boolean isProcedureInputElement(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isProcedureInputElement(elementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public b getVirtualPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        b queryPlan = (b)tableRecord.getPropertyValue("queryPlan");
        if (queryPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                queryPlan = (b)tableRecord.getPropertyValue("queryPlan");
                if (queryPlan == null) {
                    queryPlan = this.metadata.getVirtualPlan(groupID);
                    tableRecord.setPropertyValue("queryPlan", queryPlan);
                }
            }
        }
        return queryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInsertPlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
        if (insertPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
                if (insertPlan == null) {
                    insertPlan = this.metadata.getInsertPlan(groupID);
                    tableRecord.setPropertyValue("insertPlan", insertPlan);
                }
            }
        }
        return insertPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUpdatePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
        if (updatePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
                if (updatePlan == null) {
                    updatePlan = this.metadata.getUpdatePlan(groupID);
                    tableRecord.setPropertyValue("updatePlan", updatePlan);
                }
            }
        }
        return updatePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeletePlan(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
        if (deletePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
                if (deletePlan == null) {
                    deletePlan = this.metadata.getDeletePlan(groupID);
                    tableRecord.setPropertyValue("deletePlan", deletePlan);
                }
            }
        }
        return deletePlan;
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.modelSupports(modelID, modelConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.groupSupports(groupID, groupConstant);
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.elementSupports(elementID, elementConstant);
    }

    public int getMaxSetSize(Object modelID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getMaxSetSize(modelID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIndexesInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection indexes = (Collection)record.getPropertyValue("indexesInGroup");
        if (indexes == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                indexes = (Collection)record.getPropertyValue("indexesInGroup");
                if (indexes == null) {
                    indexes = this.metadata.getIndexesInGroup(groupID);
                    record.setPropertyValue("indexesInGroup", indexes);
                }
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getUniqueKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection uks = (Collection)record.getPropertyValue("uksInGroup");
        if (uks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                uks = (Collection)record.getPropertyValue("uksInGroup");
                if (uks == null) {
                    uks = this.metadata.getUniqueKeysInGroup(groupID);
                    record.setPropertyValue("uksInGroup", uks);
                }
            }
        }
        return uks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getForeignKeysInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection fks = (Collection)record.getPropertyValue("fksInGroup");
        if (fks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                fks = (Collection)record.getPropertyValue("fksInGroup");
                if (fks == null) {
                    fks = this.metadata.getForeignKeysInGroup(groupID);
                    record.setPropertyValue("fksInGroup", fks);
                }
            }
        }
        return fks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, foreignKeyID);
        MetadataRecord keyRecord = (MetadataRecord)foreignKeyID;
        Object primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
        if (primaryKey == null) {
            MetadataRecord metadataRecord = keyRecord;
            synchronized (metadataRecord) {
                primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
                if (primaryKey == null) {
                    primaryKey = this.metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                    keyRecord.setPropertyValue("primaryKeyForForeignKey", primaryKey);
                }
            }
        }
        return primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAccessPatternsInGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
        if (accPatterns == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
                if (accPatterns == null) {
                    accPatterns = this.metadata.getAccessPatternsInGroup(groupID);
                    record.setPropertyValue("accPttrnsInGroup", accPatterns);
                }
            }
        }
        return accPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInIndex(Object index) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, index);
        MetadataRecord record = (MetadataRecord)index;
        List elementIDs = (List)record.getPropertyValue("elementsInIndex");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInIndex");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInIndex(index)) != null) {
                    record.setPropertyValue("elementsInIndex", elementIDs);
                    Iterator elemntIter = elementIDs.iterator();
                    while (elemntIter.hasNext()) {
                        MetadataRecord columnRecord = (MetadataRecord)elemntIter.next();
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInKey(Object key) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, key);
        MetadataRecord record = (MetadataRecord)key;
        List elementIDs = (List)record.getPropertyValue("elementsInKey");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInKey");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInKey(key)) != null) {
                    record.setPropertyValue("elementsInKey", elementIDs);
                    Iterator elemntIter = elementIDs.iterator();
                    while (elemntIter.hasNext()) {
                        MetadataRecord columnRecord = (MetadataRecord)elemntIter.next();
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInAccessPattern(Object accessPattern) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, accessPattern);
        MetadataRecord record = (MetadataRecord)accessPattern;
        List elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInAccessPattern(accessPattern)) != null) {
                    record.setPropertyValue("elementsInAccPttrn", elementIDs);
                    Iterator elemntIter = elementIDs.iterator();
                    while (elemntIter.hasNext()) {
                        MetadataRecord columnRecord = (MetadataRecord)elemntIter.next();
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    public boolean isXMLGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isXMLGroup(groupID);
    }

    public boolean isTemporaryGroup(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.isTemporaryGroup(groupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c getMappingNode(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        c mappingNode = (c)record.getPropertyValue("mappingNodeForRecord");
        if (mappingNode == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                mappingNode = (c)record.getPropertyValue("mappingNodeForRecord");
                if (mappingNode == null) {
                    mappingNode = this.metadata.getMappingNode(groupID);
                    record.setPropertyValue("mappingNodeForRecord", mappingNode);
                }
            }
        }
        return (c)mappingNode.clone();
    }

    public String getVirtualDatabaseName() throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getVirtualDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getXMLTempGroups(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection tempGroups = (Collection)record.getPropertyValue("tempGroupsForDocument");
        if (tempGroups == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                tempGroups = (Collection)record.getPropertyValue("tempGroupsForDocument");
                if (tempGroups == null) {
                    tempGroups = this.metadata.getXMLTempGroups(groupID);
                    record.setPropertyValue("tempGroupsForDocument", tempGroups);
                }
            }
        }
        return tempGroups;
    }

    public int getCardinality(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getCardinality(groupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getXMLSchemas(Object groupID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$TableRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$TableRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.TableRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$TableRecord, groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List schemas = (List)record.getPropertyValue("schemasForDocument");
        if (schemas == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                schemas = (List)record.getPropertyValue("schemasForDocument");
                if (schemas == null) {
                    schemas = this.metadata.getXMLSchemas(groupID);
                    record.setPropertyValue("schemasForDocument", schemas);
                }
            }
        }
        return schemas;
    }

    public String getNameInSource(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNameInSource(metadataID);
    }

    public int getElementLength(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getElementLength(elementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getExtensionProperties(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord == null ? (class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord = TransformationMetadataFacade.class$("com.metamatrix.modeler.core.metadata.runtime.MetadataRecord")) : class$com$metamatrix$modeler$core$metadata$runtime$MetadataRecord, metadataID);
        MetadataRecord record = (MetadataRecord)metadataID;
        Properties extentions = (Properties)record.getPropertyValue("extentionsForRecord");
        if (extentions == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                extentions = (Properties)record.getPropertyValue("extentionsForRecord");
                if (extentions == null) {
                    extentions = this.metadata.getExtensionProperties(metadataID);
                    record.setPropertyValue("extentionsForRecord", extentions);
                }
            }
        }
        return extentions;
    }

    public String getNativeType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getNativeType(elementID);
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String getCharacterVDBResource(String resourcePath) throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String[] getVDBResourcePaths() throws MetaMatrixComponentException, QueryMetadataException {
        return null;
    }

    public String getModeledType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledType(elementID);
    }

    public String getModeledBaseType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledBaseType(elementID);
    }

    public String getModeledPrimitiveType(Object elementID) throws MetaMatrixComponentException, QueryMetadataException {
        return this.metadata.getModeledPrimitiveType(elementID);
    }

    public TransformationMetadata getDelegate() {
        return this.metadata;
    }

    private MetadataRecord getRecordByName(String fullname, char recordType) {
        Assertion.isNotZeroLength(fullname);
        Object id = this.nameToIdCache.get(this.getLookupKey(fullname, recordType));
        if (id != null) {
            return this.getRecordByID(id);
        }
        return null;
    }

    private String getFullNameByPartialName(String partialName, char recordType) {
        Assertion.isNotZeroLength(partialName);
        return (String)this.partialNameToFullNameCache.get(this.getLookupKey(partialName, recordType));
    }

    private MetadataRecord getRecordByID(Object id) {
        Assertion.isNotNull(id);
        return (MetadataRecord)this.idToRecordCache.get(id);
    }

    private void updateNameToIdCache(String fullName, char recordType, Object id) {
        if (!StringUtil.isEmpty(fullName) && id != null) {
            this.nameToIdCache.put(this.getLookupKey(fullName, recordType), id);
        }
    }

    private void updateIdToRecordCache(Object id, MetadataRecord record) {
        if (id != null && record != null) {
            this.idToRecordCache.put(id, record);
        }
    }

    private void updatePartialNameToFullName(String partialName, String fullName, char recordType) {
        if (!StringUtil.isEmpty(partialName) && !StringUtil.isEmpty(fullName)) {
            this.partialNameToFullNameCache.put(this.getLookupKey(partialName, recordType), fullName);
        }
    }

    private String getLookupKey(String name, char recordType) {
        return name.toUpperCase() + recordType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

