/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalPackage;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.aspects.sql.ColumnAspect;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.RuntimeTypeConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.f.c.e;
import com.metamatrix.query.m.d;
import com.metamatrix.query.o.h.a;
import com.metamatrix.query.o.h.c;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.b;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.r;
import com.metamatrix.query.o.j.w;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class TransformationMappingHelper
implements SqlConstants {
    private static final TransformationMappingHelper INSTANCE = new TransformationMappingHelper();
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;
    public static final int TRANSFORMATION_CHANGED = 10;
    public static final int TRANSFORMATION_UNCHANGED = 20;
    private static final IStatus TRANSFORMATION_OK_CHANGED = new Status(0, "com.metamatrix.modeler.transformation", 10, "internal: transformation parsed successfully, changes were applied", null);
    private static final IStatus TRANSFORMATION_OK_UNCHANGED = new Status(0, "com.metamatrix.modeler.transformation", 20, "internal: transformation parsed successfully, no changes applied", null);
    private static final IStatus TRANSFORMATION_ISSUE = new Status(2, "com.metamatrix.modeler.transformation", 20, "internal: transformation has warnings, no changes applied", null);
    static /* synthetic */ Class class$com$metamatrix$common$types$NullType;
    static /* synthetic */ Class class$java$lang$String;

    public static TransformationMappingHelper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconcileMappingsOnSqlChange(EObject transMappingRoot, Object source) {
        if (TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            boolean isValid;
            if (source == null) {
                source = TransformationMappingHelper.getInstance();
            }
            if ((isValid = SqlMappingRootCache.isSelectValid(transMappingRoot)) || TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
                boolean isLocked = TransformationHelper.isTargetGroupLocked(transMappingRoot);
                boolean requiredStart = ModelerCore.startTxn(false, true, "Update Atribute Mappings", source);
                boolean succeeded = false;
                try {
                    TransformationMappingHelper.reconcileSources(transMappingRoot, source);
                    if (!isLocked) {
                        TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, source);
                    }
                    AttributeMappingHelper.updateAttributeMappings(transMappingRoot, source);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, true, source);
                }
            }
        }
    }

    public static boolean[] compareQueryTargetAndSQLOutput(EObject transMappingRoot, int type) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
            TransformationMappingHelper.removeNonSelectableColumnAttributes(attributes);
            l command = TransformationHelper.getCommand(transMappingRoot, type);
            List sqlNames = TransformationSqlHelper.getProjectedSymbolNames(command);
            if (sqlNames.size() == 0 && type == 0) {
                sizesMatch = false;
            } else if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getAttributeNames(attributes);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationHelper.isValid(transMappingRoot, type)) {
                    List sqlSyms = command.gg();
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        boolean[] result = new boolean[]{sizesMatch, namesMatch, typesMatch};
        return result;
    }

    public static void removeNonSelectableColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            if (!TransformationHelper.isNonSelectableSqlColumn(iter.next())) continue;
            iter.remove();
        }
    }

    public static void removeSelectableColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            if (TransformationHelper.isNonSelectableSqlColumn(iter.next())) continue;
            iter.remove();
        }
    }

    public static void removeNonParameterColumnAttributes(List attributes) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            ColumnAspect aspect;
            EObject input = (EObject)iter.next();
            SqlAspect sqlAspect = AspectManager.getSqlAspect(input);
            if (!(sqlAspect instanceof ColumnAspect) || (aspect = (ColumnAspect)sqlAspect).isTranformationInputParameter(input)) continue;
            iter.remove();
        }
    }

    public static boolean targetAndCommandReconcile(EObject transMappingRoot, l command, boolean nameMatchReqd) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        boolean areReconciled = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributesNotInAccessPattern(transMappingRoot);
            List sqlNames = TransformationSqlHelper.getProjectedSymbolNames(command);
            if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getTargetAttributeNamesNotInAccessPattern(transMappingRoot);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationMappingHelper.commandValid(transMappingRoot, command)) {
                    List sqlSyms = command.gg();
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        if (nameMatchReqd && sizesMatch && namesMatch && typesMatch) {
            areReconciled = true;
        } else if (!nameMatchReqd && sizesMatch && typesMatch) {
            areReconciled = true;
        }
        return areReconciled;
    }

    private static boolean typesMatch(j seSymbol, EObject attribute) {
        Class symType;
        boolean typesMatch = false;
        if (seSymbol != null && attribute != null && (symType = seSymbol.ag()) != null && symType != DataTypeManager.DefaultDataClasses.NULL && RuntimeTypeConverter.isExplicitMatch(seSymbol, attribute)) {
            typesMatch = true;
        }
        return typesMatch;
    }

    private static boolean allTypesMatch(List symbolList, List attributeList) {
        if (symbolList != null && attributeList != null && symbolList.size() == attributeList.size()) {
            for (int i2 = 0; i2 < symbolList.size(); ++i2) {
                EObject attr;
                j seSymbol = (j)symbolList.get(i2);
                if (TransformationMappingHelper.typesMatch(seSymbol, attr = (EObject)attributeList.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean allStringsMatch(List list1, List list2) {
        if (list1 != null && list2 != null && list1.size() == list2.size()) {
            for (int i2 = 0; i2 < list1.size(); ++i2) {
                String str2;
                String str1 = (String)list1.get(i2);
                if (str1.equalsIgnoreCase(str2 = (String)list2.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean commandValid(EObject transMappingRoot, l command) {
        TransformationValidator validator;
        e result;
        boolean isValid = false;
        if (!command.f9() && (result = (validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot)).validateSql(command.toString(), 0, false, false)).isValidatable()) {
            isValid = true;
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconcileSources(EObject transMappingRoot, Object source) {
        boolean isValid;
        boolean success = false;
        if (source == null) {
            source = TransformationMappingHelper.getInstance();
        }
        if ((isValid = SqlMappingRootCache.isSelectValid(transMappingRoot)) && !TransformationMappingHelper.isReadOnly(transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Reconcile Sources", source);
            boolean succeeded = false;
            try {
                TransformationHelper.reconcileInputsAndAliases(transMappingRoot);
                l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
                List symbolsToAdd = TransformationMappingHelper.getGroupSymbolsNotInMapping(transMappingRoot, command);
                List subqueryFromClausesToAdd = TransformationMappingHelper.getSubqueryFromClausesNotInMapping(transMappingRoot, command);
                List storedProcsToAdd = TransformationMappingHelper.getStoredProcsNotInMapping(transMappingRoot, command);
                List allAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
                List aliasesInCommand = TransformationMappingHelper.getSqlAliasesInCommand(transMappingRoot, command);
                ArrayList aliasesToRemove = new ArrayList(allAliases.size());
                aliasesToRemove.addAll(allAliases);
                aliasesToRemove.removeAll(aliasesInCommand);
                Iterator iter = aliasesToRemove.iterator();
                while (iter.hasNext()) {
                    SqlAlias sqlAlias = (SqlAlias)iter.next();
                    EObject sqlEObj = sqlAlias.getAliasedObject();
                    String sqlAliasName = sqlAlias.getAlias();
                    TransformationHelper.removeSourceAlias(transMappingRoot, sqlEObj, sqlAliasName, true, source);
                }
                iter = symbolsToAdd.iterator();
                while (iter.hasNext()) {
                    f gSymbol = (f)iter.next();
                    EObject symbolEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                    String symbolName = TransformationSqlHelper.getGroupSymbolShortName(gSymbol);
                    if (symbolEObj == null) continue;
                    TransformationHelper.addSqlAlias(transMappingRoot, symbolEObj, symbolName, true, source);
                }
                iter = subqueryFromClausesToAdd.iterator();
                while (iter.hasNext()) {
                    b subqueryFrom = (b)iter.next();
                    l subCommand = subqueryFrom.r();
                    if (!(subCommand instanceof w)) continue;
                    w storedProc = (w)subCommand;
                    EObject procEObj = TransformationSqlHelper.getStoredProcedureEObject(storedProc);
                    String procName = subqueryFrom.c4();
                    if (procEObj == null) continue;
                    TransformationHelper.addSqlAlias(transMappingRoot, procEObj, procName, true, source);
                }
                iter = storedProcsToAdd.iterator();
                while (iter.hasNext()) {
                    w storedProc = (w)iter.next();
                    EObject procEObj = TransformationSqlHelper.getStoredProcedureEObject(storedProc);
                    String procName = storedProc.hs();
                    if (procEObj == null) continue;
                    TransformationHelper.addSqlAlias(transMappingRoot, procEObj, procName, true, source);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Reconcile Sources", source);
            boolean succeeded = false;
            try {
                TransformationHelper.removeAllSourcesAndAliases(transMappingRoot, true, source);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return success;
    }

    private static List getGroupSymbolsNotInMapping(EObject transMappingRoot, l command) {
        ArrayList<f> symbolList = new ArrayList<f>();
        Collection sqlGroupSymbols = TransformationSqlHelper.getGroupSymbols(command);
        List mappingAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        Iterator iter = sqlGroupSymbols.iterator();
        while (iter.hasNext()) {
            f gSymbol = (f)iter.next();
            if (TransformationMappingHelper.groupSymbolInAliasList(gSymbol, mappingAliases) || gSymbol.aq() instanceof d) continue;
            symbolList.add(gSymbol);
        }
        return symbolList;
    }

    private static List getSubqueryFromClausesNotInMapping(EObject transMappingRoot, l command) {
        ArrayList<b> resultList = new ArrayList<b>();
        List subqueryFromClauses = a.d8(command);
        List mappingAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        Iterator iter = subqueryFromClauses.iterator();
        while (iter.hasNext()) {
            b subqueryFrom = (b)iter.next();
            if (TransformationMappingHelper.subqueryFromClauseInAliasList(subqueryFrom, mappingAliases)) continue;
            resultList.add(subqueryFrom);
        }
        return resultList;
    }

    private static List getStoredProcsNotInMapping(EObject transMappingRoot, l command) {
        ArrayList<w> resultList = new ArrayList<w>();
        ArrayList<l> allCommands = new ArrayList<l>();
        allCommands.add(command);
        allCommands.addAll(c.eb(command));
        Iterator iter = allCommands.iterator();
        while (iter.hasNext()) {
            List mappingAliases;
            w storedProc;
            l cmd = (l)iter.next();
            if (!(cmd instanceof w) || TransformationMappingHelper.storedProcInAliasList(storedProc = (w)cmd, mappingAliases = TransformationHelper.getAllSqlAliases(transMappingRoot))) continue;
            resultList.add(storedProc);
        }
        return resultList;
    }

    public static boolean groupSymbolInAliasList(f gSymbol, List sqlAliases) {
        boolean inSqlList = false;
        EObject groupEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
        String groupName = TransformationSqlHelper.getGroupSymbolShortName(gSymbol);
        if (groupEObj != null && groupName != null) {
            Iterator iter = sqlAliases.iterator();
            while (iter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)iter.next();
                EObject aEObj = sqlAlias.getAliasedObject();
                String aName = sqlAlias.getAlias();
                if (aEObj == null || aName == null || !aEObj.equals(groupEObj) || !aName.equalsIgnoreCase(groupName)) continue;
                inSqlList = true;
                break;
            }
        }
        return inSqlList;
    }

    private static boolean subqueryFromClauseInAliasList(b subqueryFrom, List sqlAliases) {
        boolean inSqlList = false;
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            if (!TransformationSqlHelper.isMatch(subqueryFrom, sqlAlias)) continue;
            inSqlList = true;
            break;
        }
        return inSqlList;
    }

    private static boolean storedProcInAliasList(w storedProc, List sqlAliases) {
        boolean inSqlList = false;
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            if (!TransformationSqlHelper.isMatch(storedProc, sqlAlias)) continue;
            inSqlList = true;
            break;
        }
        return inSqlList;
    }

    private static List getSqlAliasesInCommand(EObject transMappingRoot, l command) {
        ArrayList<SqlAlias> aliasList = new ArrayList<SqlAlias>();
        ArrayList<l> allCommands = new ArrayList<l>();
        allCommands.add(command);
        allCommands.addAll(c.eb(command));
        Iterator cIter = allCommands.iterator();
        while (cIter.hasNext()) {
            l cmd = (l)cIter.next();
            Collection sqlGroupSymbols = TransformationSqlHelper.getGroupSymbols(cmd);
            TransformationMappingHelper.removeTempIDGroupSymbols(sqlGroupSymbols);
            List subqueryFromClauses = a.d8(cmd);
            w storedProc = null;
            if (cmd instanceof w) {
                storedProc = (w)cmd;
            }
            List mappingAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
            Iterator iter = mappingAliases.iterator();
            while (iter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)iter.next();
                if (!TransformationMappingHelper.sqlAliasInGroupSymbolList(sqlAlias, sqlGroupSymbols) && !TransformationMappingHelper.sqlAliasInSubqueryFromList(sqlAlias, subqueryFromClauses) && !TransformationSqlHelper.isMatch(storedProc, sqlAlias) || aliasList.contains(sqlAlias)) continue;
                aliasList.add(sqlAlias);
            }
        }
        return aliasList;
    }

    private static void removeTempIDGroupSymbols(Collection groupSymbols) {
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            f gSymbol = (f)iter.next();
            if (!(gSymbol.aq() instanceof d)) continue;
            iter.remove();
        }
    }

    public static boolean sqlAliasInGroupSymbolList(SqlAlias sqlAlias, Collection groupSymbols) {
        boolean inGroupSymbolList = false;
        EObject aliasEObj = sqlAlias.getAliasedObject();
        String aliasName = sqlAlias.getAlias();
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            f gSymbol = (f)iter.next();
            EObject groupEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
            String groupName = TransformationSqlHelper.getGroupSymbolShortName(gSymbol);
            if (groupEObj == null || groupName == null || !groupEObj.equals(aliasEObj) || !groupName.equalsIgnoreCase(aliasName)) continue;
            inGroupSymbolList = true;
            break;
        }
        return inGroupSymbolList;
    }

    public static boolean sqlAliasInSubqueryFromList(SqlAlias sqlAlias, Collection subqueryFromClauses) {
        boolean inSubqueryFromList = false;
        Iterator iter = subqueryFromClauses.iterator();
        while (iter.hasNext()) {
            b subqueryFrom = (b)iter.next();
            if (!TransformationSqlHelper.isMatch(subqueryFrom, sqlAlias)) continue;
            inSubqueryFromList = true;
            break;
        }
        return inSubqueryFromList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, boolean reconcileMappingClassTarget, Object txnSource) {
        boolean success = false;
        boolean changed = false;
        if (!TransformationHelper.isTargetGroupLocked(transMappingRoot)) {
            EObject targetGroup;
            if (txnSource == null) {
                txnSource = TransformationMappingHelper.getInstance();
            }
            if ((targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) instanceof MappingClass && !(targetGroup instanceof StagingTable) && !reconcileMappingClassTarget) {
                return TRANSFORMATION_ISSUE;
            }
            boolean hasXMLDocSource = false;
            List sources = TransformationHelper.getTransformationSources(transMappingRoot);
            if (sources.size() == 1 && sources.get(0) instanceof XmlDocument) {
                hasXMLDocSource = true;
            }
            boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            l validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            }
            if (targetGroup != null && validCommand != null) {
                boolean requiredStart = ModelerCore.startTxn(false, true, "Reconcile Target Attributes", txnSource);
                boolean succeeded = false;
                try {
                    List currentTargetAttrNames = TransformationMappingHelper.getTargetAttributeNames(transMappingRoot);
                    List projectedSymbolNames = null;
                    EObject linkTarget = TransformationHelper.getTransformationLinkTarget(transMappingRoot);
                    projectedSymbolNames = TransformationHelper.isSqlVirtualProcedure(linkTarget) ? TransformationSqlHelper.getProjectedSymbolUniqueNames(validCommand) : TransformationSqlHelper.getProjectedSymbolAndProcInputUniqueNames(validCommand);
                    int nCurrentTargetAttrs = currentTargetAttrNames.size();
                    int nProjectedSymbols = projectedSymbolNames.size();
                    if (nProjectedSymbols < nCurrentTargetAttrs) {
                        TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                        IStatus iStatus = TRANSFORMATION_ISSUE;
                        return iStatus;
                    }
                    List matchedNames = TransformationMappingHelper.getMatchedNames(currentTargetAttrNames, projectedSymbolNames);
                    List unmatchedVirtualNames = TransformationMappingHelper.removeNames(currentTargetAttrNames, matchedNames);
                    if (unmatchedVirtualNames.size() != 0) {
                        TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                        IStatus iStatus = TRANSFORMATION_ISSUE;
                        return iStatus;
                    }
                    List extraSymbolNames = TransformationMappingHelper.removeNames(projectedSymbolNames, matchedNames);
                    Map eObjectMap = TransformationSqlHelper.getProjectedSymbolAndProcInputEObjects(validCommand);
                    if (extraSymbolNames.size() != 0) {
                        TransformationMappingHelper.addTargetAttributes(extraSymbolNames, eObjectMap, targetGroup, txnSource);
                        changed = true;
                    }
                    TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                    changed = TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames) || changed;
                    Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolAndProcInputUniqueTypes(validCommand);
                    boolean bl = changed = TransformationMappingHelper.setGroupAttributeTypes(targetGroup, symbolTypeMap) || changed;
                    if (!(targetGroup instanceof MappingClass)) {
                        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolAndProcInputLengths(validCommand, hasXMLDocSource);
                        changed = TransformationMappingHelper.setGroupAttributeLengths(targetGroup, symbolLengthMap) || changed;
                    }
                    changed = AttributeMappingHelper.updateAttributeMappings(transMappingRoot, txnSource) || changed;
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (changed && requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, true, txnSource);
                }
                success = true;
            }
        }
        IStatus rv = success ? (changed ? TRANSFORMATION_OK_CHANGED : TRANSFORMATION_OK_UNCHANGED) : TRANSFORMATION_ISSUE;
        return rv;
    }

    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, Object txnSource) {
        return TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, false, txnSource);
    }

    public static void addTargetAttrsForProcedureInputParams(EObject transMappingRoot, EObject targetGroup, List sources, Object txnSource) {
        ArrayList procSources = new ArrayList(sources.size());
        ArrayList procInputParams = new ArrayList();
        ArrayList procInOutParams = new ArrayList();
        ArrayList procOutputParams = new ArrayList();
        ArrayList procResultCols = new ArrayList();
        Iterator sIter = sources.iterator();
        while (sIter.hasNext()) {
            Object source = sIter.next();
            if (!TransformationHelper.isSqlProcedure(source)) continue;
            procSources.add(source);
            procInputParams.addAll(TransformationHelper.getInAndInoutParameters((EObject)source));
            procInOutParams.addAll(TransformationHelper.getInoutParameters((EObject)source));
            procOutputParams.addAll(TransformationHelper.getOutAndReturnParameters((EObject)source));
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)source);
            Object resultSet = procedureAspect.getResult((EObject)source);
            if (!SqlAspectHelper.isProcedureResultSet((EObject)resultSet)) continue;
            SqlColumnSetAspect rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)resultSet);
            List rsCols = rsAspect.getColumns((EObject)resultSet);
            procResultCols.addAll(rsCols);
        }
        if (!procSources.isEmpty() && TransformationHelper.isVirtualSqlTable(targetGroup)) {
            ArrayList<String> colsToCreate = new ArrayList<String>();
            HashMap<String, EObject> typeMap = new HashMap<String, EObject>();
            HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
            List allCols = TransformationHelper.getTargetAttributes(targetGroup);
            Iterator ipIter = procInputParams.iterator();
            while (ipIter.hasNext()) {
                Object ip = ipIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)ip);
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator ipIter2 = procInOutParams.iterator();
            while (ipIter2.hasNext()) {
                Object ip = ipIter2.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)ip);
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator opIter = procOutputParams.iterator();
            while (opIter.hasNext()) {
                Object ip = opIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip)) continue;
                SqlProcedureParameterAspect aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)ip);
                String paramName = aspect.getName((EObject)ip);
                EObject paramType = aspect.getDatatype((EObject)ip);
                int paramLength = aspect.getLength((EObject)ip);
                if (TransformationMappingHelper.containsName(allCols, paramName)) continue;
                colsToCreate.add(paramName);
                typeMap.put(paramName, paramType);
                lengthMap.put(paramName, new Integer(paramLength));
            }
            Iterator rsIter = procResultCols.iterator();
            while (rsIter.hasNext()) {
                Object col = rsIter.next();
                if (!TransformationHelper.isSqlColumn(col)) continue;
                SqlColumnAspect colAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)col);
                String colName = colAspect.getName((EObject)col);
                EObject colType = colAspect.getDatatype((EObject)col);
                int colLength = colAspect.getLength((EObject)col);
                if (TransformationMappingHelper.containsName(allCols, colName)) continue;
                colsToCreate.add(colName);
                typeMap.put(colName, colType);
                lengthMap.put(colName, new Integer(colLength));
            }
            if (!colsToCreate.isEmpty()) {
                TransformationMappingHelper.addTargetAttributes(targetGroup, colsToCreate, txnSource);
                TransformationMappingHelper.setGroupAttributeTypes(targetGroup, typeMap);
                TransformationMappingHelper.setGroupAttributeLengths(targetGroup, lengthMap);
            }
            List colsNotInAP = TransformationHelper.getTransformationTargetAttributesNotInAccessPattern(transMappingRoot);
            ArrayList<EObject> colsToAddToAP = new ArrayList<EObject>(colsNotInAP.size());
            ipIter = procInputParams.iterator();
            boolean isMappingClass = targetGroup instanceof MappingClass;
            while (!isMappingClass && ipIter.hasNext()) {
                SqlProcedureParameterAspect aspect;
                String paramName;
                EObject attrObj;
                Object ip = ipIter.next();
                if (!TransformationHelper.isSqlProcedureParameter(ip) || (attrObj = TransformationMappingHelper.getListAttrByName(colsNotInAP, paramName = (aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)ip)).getName((EObject)ip))) == null) continue;
                if (attrObj instanceof Column) {
                    ((Column)attrObj).setSelectable(false);
                }
                colsToAddToAP.add(attrObj);
            }
            if (!colsToAddToAP.isEmpty()) {
                SqlTableAspect tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect(targetGroup);
                Collection accessPatterns = tableAspect.getAccessPatterns(targetGroup);
                AccessPattern accessPattern = null;
                l selectCommand = TransformationHelper.getCommand(transMappingRoot, 0);
                List inParamNames = TransformationSqlHelper.getProcedureInputParamNames(selectCommand);
                Iterator apIter = accessPatterns.iterator();
                boolean useExistingAP = false;
                while (apIter.hasNext()) {
                    accessPattern = (AccessPattern)apIter.next();
                    EList aPatternCols = accessPattern.getColumns();
                    Iterator apColIter = aPatternCols.iterator();
                    boolean goodAP = true;
                    while (apColIter.hasNext()) {
                        Column col = (Column)apColIter.next();
                        String apColName = col.getName();
                        if (apColName == null || inParamNames.contains(apColName)) continue;
                        goodAP = false;
                        break;
                    }
                    if (!goodAP) continue;
                    useExistingAP = true;
                    break;
                }
                if (!useExistingAP || accessPattern == null) {
                    accessPattern = RelationalPackage.eINSTANCE.getRelationalFactory().createAccessPattern();
                    accessPattern.setName("AccessPattern");
                    if (targetGroup instanceof Table) {
                        accessPattern.setTable((Table)targetGroup);
                    }
                }
                try {
                    ModelerCore.getModelEditor().addValue(accessPattern, colsToAddToAP, accessPattern.getColumns(), 0);
                }
                catch (ModelerCoreException e2) {
                    TransformationPlugin.Util.log(e2);
                }
                SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, false, txnSource);
            }
        }
    }

    public static boolean hasProcedure(List objList) {
        boolean hasProcedure = false;
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            Object source = iter.next();
            if (!TransformationHelper.isSqlProcedure(source)) continue;
            hasProcedure = true;
            break;
        }
        return hasProcedure;
    }

    public static List getTargetAttributeNames(EObject transMappingRoot) {
        List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
        return TransformationMappingHelper.getAttributeNames(attributes);
    }

    public static List getTargetAttributeNamesNotInAccessPattern(EObject transMappingRoot) {
        List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
        List apAttributes = TransformationHelper.getTransformationTargetAttributesInAccessPattern(transMappingRoot);
        attributes.removeAll(apAttributes);
        return TransformationMappingHelper.getAttributeNames(attributes);
    }

    public static List getAttributeNames(List attributes) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            EObject attr = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn(attr)) continue;
            if (SqlAspectHelper.isXmlDocument(attr)) {
                attributeNames.add("xml");
                continue;
            }
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(attr);
            attributeNames.add(columnAspect.getName(attr));
        }
        return attributeNames;
    }

    private static List getMatchedNames(List list1, List list2) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator list1Iter = list1.iterator();
        block0: while (list1Iter.hasNext()) {
            String list1Str = (String)list1Iter.next();
            if (list1Str == null) continue;
            Iterator list2Iter = list2.iterator();
            while (list2Iter.hasNext()) {
                String list2Str = (String)list2Iter.next();
                if (!list1Str.equalsIgnoreCase(list2Str)) continue;
                newList.add(list1Str);
                continue block0;
            }
        }
        return newList;
    }

    private static List removeNames(List list, List removeList) {
        ArrayList newList = new ArrayList(list);
        Iterator removeIter = removeList.iterator();
        block0: while (removeIter.hasNext()) {
            String removeStr = (String)removeIter.next();
            Iterator newListIter = newList.iterator();
            while (newListIter.hasNext()) {
                String listName = (String)newListIter.next();
                if (listName == null || !listName.equalsIgnoreCase(removeStr)) continue;
                newListIter.remove();
                continue block0;
            }
        }
        return newList;
    }

    public static void resetSelectSqlOnNameConflict(l command, EObject transMappingRoot, boolean isSignificant, Object source) {
        af newQuery;
        if (command != null && command instanceof af && TransformationSqlHelper.hasProjectedSymbolNameConflict(command) && (newQuery = TransformationSqlHelper.createQueryFixNameConflicts((af)command)) != null) {
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), isSignificant, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetAttributes(EObject targetEObject, List attributeNames, Object source) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Add Target Attributes", source);
            boolean succeeded = false;
            try {
                String attrName = null;
                Iterator iter = attributeNames.iterator();
                while (iter.hasNext()) {
                    attrName = (String)iter.next();
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    if (paramToCreate == null) continue;
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName);
                    }
                    catch (ModelerCoreException theException) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorCreatingAttribute", attrName);
                        TransformationPlugin.Util.log(4, theException, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private static Command getSqlColumnDescriptor(EObject targetEObject) {
        EObject eObj;
        Command colDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e2) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.getChildDescriptorError", targetEObject.toString());
            TransformationPlugin.Util.log(4, e2, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !SqlAspectHelper.isColumn(eObj = (EObject)(colDescriptor = (Command)iter.next()).getResult().iterator().next())) {
        }
        return colDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetAttributes(List attributeNames, Map sourceEObjectMap, EObject targetEObject, Object txnSource) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Add Target Attributes", txnSource);
            boolean succeeded = false;
            try {
                String attrName = null;
                Iterator iter = attributeNames.iterator();
                while (iter.hasNext()) {
                    attrName = (String)iter.next();
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    EObject srcEObj = (EObject)sourceEObjectMap.get(attrName);
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName);
                        TransformationHelper.transferSqlColumnProperties(newEObject, srcEObj, txnSource);
                    }
                    catch (ModelerCoreException e2) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.createNewAttrError", targetEObject.toString());
                        TransformationPlugin.Util.log(4, e2, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTargetAttributes(Object mappingRoot, List attributes, boolean isSignificant, Object source) {
        boolean requiredStart = ModelerCore.startTxn(isSignificant, true, "Add Target Attributes", source);
        boolean succeeded = false;
        try {
            SqlTransformationMappingRoot transMappingRoot = null;
            if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
                transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
            }
            EObject virtualTarget = TransformationHelper.getTransformationTarget(transMappingRoot);
            ArrayList<EObject> deleteList = new ArrayList<EObject>();
            if (SqlAspectHelper.isTable(virtualTarget) || SqlAspectHelper.isColumnSet(virtualTarget)) {
                List columns = null;
                if (SqlAspectHelper.isTable(virtualTarget)) {
                    SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect(virtualTarget);
                    columns = tableAspect.getColumns(virtualTarget);
                } else if (SqlAspectHelper.isColumnSet(virtualTarget)) {
                    SqlColumnSetAspect columnSetAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect(virtualTarget);
                    columns = columnSetAspect.getColumns(virtualTarget);
                }
                Iterator colIter = columns.iterator();
                while (colIter.hasNext()) {
                    SqlColumnAspect columnAspect;
                    EObject attr = (EObject)colIter.next();
                    if (!SqlAspectHelper.isColumn(attr) || !TransformationMappingHelper.containsName(attributes, (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(attr)).getName(attr))) continue;
                    deleteList.add(attr);
                }
            }
            if (deleteList.size() > 0) {
                try {
                    ModelerCore.getModelEditor().delete(deleteList);
                }
                catch (ModelerCoreException e2) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorDeletingAttributes");
                    TransformationPlugin.Util.log(4, e2, message);
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static boolean containsName(List attributes, String name) {
        boolean contains = false;
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            String objName;
            EObject eObj = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn(eObj) || !(objName = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(eObj)).getName(eObj)).equalsIgnoreCase(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static EObject getListAttrByName(List attributes, String name) {
        EObject result = null;
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            String objName;
            EObject eObj = (EObject)iter.next();
            if (!SqlAspectHelper.isColumn(eObj) || !(objName = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(eObj)).getName(eObj)).equalsIgnoreCase(name)) continue;
            result = eObj;
            break;
        }
        return result;
    }

    public static boolean hasTypeConflict(Object attribute, Object symbol) {
        return !RuntimeTypeConverter.isExplicitMatch(attribute, symbol);
    }

    public static boolean orderGroupAttributes(EObject transMappingRoot, boolean requiresValidSelect, l modifiedCommand) {
        if (!TransformationHelper.isTargetGroupLocked(transMappingRoot)) {
            boolean isValid = true;
            if (requiresValidSelect) {
                isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            }
            l validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand(transMappingRoot);
                EObject targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot);
                List projectedSymbolNames = null;
                projectedSymbolNames = modifiedCommand != null && validCommand instanceof r ? TransformationSqlHelper.getProjectedSymbolUniqueNames(modifiedCommand) : TransformationSqlHelper.getProjectedSymbolUniqueNames(validCommand);
                return TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames);
            }
        }
        return false;
    }

    private static boolean orderGroupAttributes(EObject groupEObject, List attrNames) {
        List columnIndices = TransformationMappingHelper.getColumnIndices(groupEObject);
        boolean attributeMoved = false;
        if (columnIndices.size() == attrNames.size()) {
            for (int i2 = 0; i2 < attrNames.size(); ++i2) {
                String name = (String)attrNames.get(i2);
                boolean wasMoved = TransformationMappingHelper.moveAttribute(groupEObject, name, (Integer)columnIndices.get(i2));
                if (!wasMoved) continue;
                attributeMoved = wasMoved;
            }
        }
        return attributeMoved;
    }

    private static boolean setGroupAttributeTypes(EObject groupEObject, Map attrTypeMap) {
        boolean changed = false;
        EList children = groupEObject.eContents();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject dtype;
            String colName;
            EObject child = (EObject)iter.next();
            if (!TransformationHelper.isSqlColumn(child) || !attrTypeMap.containsKey(colName = TransformationHelper.getSqlEObjectName(child)) || (dtype = TransformationHelper.getSqlColumnDatatype(child)) != null) continue;
            TransformationMappingHelper.setAttributeType(child, attrTypeMap.get(colName));
            changed = true;
        }
        return changed;
    }

    public static boolean setGroupAttributeLengths(EObject groupEObject, Map attrLengthMap) {
        boolean changed = false;
        if (attrLengthMap != null && !attrLengthMap.isEmpty()) {
            EList children = groupEObject.eContents();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                SqlColumnAspect columnAspect;
                String targetColName;
                EObject child = (EObject)iter.next();
                if (!TransformationHelper.isSqlColumn(child) || !attrLengthMap.containsKey(targetColName = TransformationHelper.getSqlEObjectName(child))) continue;
                int currentLength = TransformationHelper.getSqlColumnLength(child);
                int length = (Integer)attrLengthMap.get(targetColName);
                if (currentLength > 0 || length == -1 || !(columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(child)).canSetLength()) continue;
                TransformationMappingHelper.setAttributeLength(child, length);
                changed = true;
            }
        }
        return changed;
    }

    private static List getColumnIndices(EObject groupEObject) {
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        EList children = groupEObject.eContents();
        for (int i2 = 0; i2 < children.size(); ++i2) {
            if (!TransformationHelper.isSqlColumn(children.get(i2))) continue;
            columnIndices.add(new Integer(i2));
        }
        return columnIndices;
    }

    private static boolean moveAttribute(EObject groupEObject, String attrName, int newIndex) {
        EList children = groupEObject.eContents();
        boolean moved = false;
        Iterator iter = children.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String currentAttrName;
            EObject eObj = (EObject)iter.next();
            if (TransformationHelper.isSqlColumn(eObj) && (currentAttrName = TransformationHelper.getSqlEObjectName(eObj)).equalsIgnoreCase(attrName) && newIndex != index) {
                try {
                    ModelerCore.getModelEditor().move(groupEObject, eObj, newIndex);
                    moved = true;
                }
                catch (ModelerCoreException err) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.moveTargetAttrError", groupEObject.toString());
                    TransformationPlugin.Util.log(4, err, message);
                }
                break;
            }
            ++index;
        }
        return moved;
    }

    private static void setAttributeType(EObject attrEObject, Object typeObj) {
        if (TransformationHelper.isSqlColumn(attrEObject)) {
            EObject newDatatype = TransformationMappingHelper.getDatatype(typeObj);
            EObject currentDatatype = TransformationHelper.getSqlColumnDatatype(attrEObject);
            if (newDatatype == null && currentDatatype != null || newDatatype != null && !newDatatype.equals(currentDatatype)) {
                TransformationHelper.setSqlColumnDatatype(attrEObject, newDatatype, TransformationMappingHelper.getInstance());
            }
        }
    }

    private static void setAttributeLength(EObject attrEObject, int newLength) {
        int currentLength;
        if (TransformationHelper.isSqlColumn(attrEObject) && newLength != (currentLength = TransformationHelper.getSqlColumnLength(attrEObject))) {
            TransformationHelper.setSqlColumnLength(attrEObject, newLength, TransformationMappingHelper.getInstance());
        }
    }

    private static EObject getDatatype(Object typeObj) {
        EObject datatype = null;
        if (typeObj != null) {
            if (typeObj instanceof EObject) {
                EObject eObject = (EObject)typeObj;
                DatatypeManager dtMgr = ModelerCore.getDatatypeManager(eObject, true);
                if (dtMgr.isSimpleDatatype(eObject)) {
                    datatype = (EObject)typeObj;
                }
            } else if (typeObj instanceof Class) {
                if (typeObj == (class$com$metamatrix$common$types$NullType == null ? (class$com$metamatrix$common$types$NullType = TransformationMappingHelper.class$("com.metamatrix.common.types.NullType")) : class$com$metamatrix$common$types$NullType)) {
                    typeObj = class$java$lang$String == null ? (class$java$lang$String = TransformationMappingHelper.class$("java.lang.String")) : class$java$lang$String;
                }
                String runtimeTypeName = DataTypeManager.getDataTypeName((Class)typeObj);
                datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
            }
        }
        return datatype;
    }

    public static EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) {
        DatatypeManager dtMgr;
        EObject datatype = null;
        EObject typeEObj = null;
        try {
            typeEObj = ModelerCore.getWorkspaceDatatypeManager().getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
        }
        catch (ModelerCoreException e2) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorFindingDefaultType", runtimeTypeName);
            TransformationPlugin.Util.log(4, e2, message);
        }
        if (typeEObj != null && (dtMgr = ModelerCore.getDatatypeManager(typeEObj, true)).isSimpleDatatype(typeEObj)) {
            return typeEObj;
        }
        return datatype;
    }

    private static boolean isReadOnly(EObject theEObject) {
        ModelResource modelResource;
        boolean result = true;
        if (theEObject != null && (modelResource = ModelerCore.getModelEditor().findModelResource(theEObject)) != null) {
            result = ModelUtil.isIResourceReadOnly(modelResource.getResource());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

