/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.modeler.core.workspace.ModelBuffer;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.workspace.InternalOpenable;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferManager;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceItemImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.OpenableModelWorkspaceItemInfo;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class OpenableImpl
extends ModelWorkspaceItemImpl
implements Openable,
InternalOpenable {
    protected OpenableImpl(int type, ModelWorkspaceItem parent, String name) {
        super(type, parent, name);
    }

    public IResource getCorrespondingResource() throws ModelWorkspaceException {
        return this.getUnderlyingResource();
    }

    public Openable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        IResource parentResource = this.fParent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.fName);
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected void buildStructure(OpenableModelWorkspaceItemInfo info, IProgressMonitor monitor) throws ModelWorkspaceException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        Iterator iter = newElements.keySet().iterator();
        while (iter.hasNext()) {
            ModelWorkspaceItem key = (ModelWorkspaceItem)iter.next();
            Object value = newElements.get(key);
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(key, value);
        }
        ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
    }

    protected abstract OpenableModelWorkspaceItemInfo createItemInfo();

    protected void closing(Object info) throws ModelWorkspaceException {
        OpenableModelWorkspaceItemInfo openableInfo = (OpenableModelWorkspaceItemInfo)info;
        this.closeBuffer(openableInfo);
        super.closing(info);
    }

    public void openWhenClosed(IProgressMonitor pm) throws ModelWorkspaceException {
        try {
            if (ModelWorkspaceManager.VERBOSE) {
                System.out.println("OPENING Item (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
            }
            this.openParent(pm);
            OpenableModelWorkspaceItemInfo info = this.createItemInfo();
            this.buildStructure(info, pm);
            this.opening(info);
            if (ModelWorkspaceManager.VERBOSE) {
                System.out.println("-> Package cache size = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.pkgSize());
                System.out.println("-> Openable cache filling ratio = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.openableFillingRatio() + "%");
            }
        }
        catch (ModelWorkspaceException e2) {
            ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            throw e2;
        }
    }

    protected abstract boolean generateInfos(OpenableModelWorkspaceItemInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws ModelWorkspaceException;

    public boolean exists() {
        return this.parentExists() && this.resourceExists();
    }

    public boolean hasChildren() throws ModelWorkspaceException {
        return this.getChildren().length > 0;
    }

    public boolean hasUnsavedChanges() throws ModelWorkspaceException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        if (this.hasBuffer()) {
            ModelBuffer buffer = this.getBufferManager().getOpenBuffer(this);
            if (buffer == null) {
                return false;
            }
            if (buffer.hasUnsavedChanges()) {
                return true;
            }
        }
        if (this.fType == 4 || this.fType == 2 || this.fType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                ModelWorkspaceItem owner;
                ModelBuffer buffer = (ModelBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (ModelWorkspaceItem)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws ModelWorkspaceException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        ModelWorkspaceManager modelWorkspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
        synchronized (modelWorkspaceManager) {
            return ModelWorkspaceManager.getModelWorkspaceManager().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws ModelWorkspaceException {
        if (!this.isConsistent()) {
            this.buildStructure((OpenableModelWorkspaceItemInfo)this.getItemInfo(), pm);
        }
    }

    public void open(IProgressMonitor pm) throws ModelWorkspaceException {
        if (!this.isOpen()) {
            this.openWhenClosed(pm);
        }
    }

    protected void openParent(IProgressMonitor pm) throws ModelWorkspaceException {
        OpenableImpl openableParent = (OpenableImpl)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.openWhenClosed(pm);
        }
    }

    protected boolean parentExists() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return true;
        }
        return parent.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return ModelWorkspaceImpl.getTarget(workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelWorkspaceException {
        if (this.isReadOnly() || ModelUtil.isIResourceReadOnly(this.getResource())) {
            throw new ModelWorkspaceException(new ModelStatusImpl(976, this));
        }
        ModelBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
            ((ModelBufferImpl)buf).refresh(pm);
        }
    }

    protected ModelBufferManager getBufferManager() {
        return ModelBufferManager.getDefaultBufferManager();
    }

    public ModelBuffer getBufferHack() throws ModelWorkspaceException {
        ModelBuffer buf = this.getBuffer();
        if (!this.getResource().exists() && this.getResource().getLocation().toFile().exists()) {
            try {
                this.getResource().refreshLocal(2, null);
            }
            catch (CoreException err) {
                throw new ModelWorkspaceException(err);
            }
        }
        return buf;
    }

    public synchronized ModelBuffer getBuffer() throws ModelWorkspaceException {
        if (this.hasBuffer()) {
            ModelBuffer buffer;
            if (!this.isOpen()) {
                this.getItemInfo();
            }
            if ((buffer = this.getBufferManager().getOpenBuffer(this)) == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    protected ModelBuffer openBuffer(IProgressMonitor pm) throws ModelWorkspaceException {
        return null;
    }

    protected void closeBuffer(OpenableModelWorkspaceItemInfo info) {
        if (!this.hasBuffer()) {
            return;
        }
        ModelBuffer buffer = this.getBufferManager().getOpenBuffer(this);
        if (buffer != null) {
            buffer.close();
            this.getBufferManager().removeBuffer(buffer);
        }
    }

    protected boolean hasBuffer() {
        return false;
    }
}

