/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.metamodels.transformation.FragmentMappingRoot;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelTransformations;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.NonOpenableModelWorkspaceItemImpl;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public class ModelTransformationsImpl
extends NonOpenableModelWorkspaceItemImpl
implements ModelTransformations {
    private static final String CREATE_TRANSFORMATION_ERROR = "ModelTransformationsImpl.createTransformationMessage";
    protected static final String DEFAULT_NAME = ModelerCore.Util.getString("ModelTransformationsImpl.defaultName");

    ModelTransformationsImpl() {
        super(9, null, DEFAULT_NAME);
    }

    public ModelTransformationsImpl(ModelWorkspaceItem parent) {
        super(9, parent, DEFAULT_NAME);
    }

    public ModelResource getModelResource() {
        return (ModelResource)this.getParent();
    }

    public IResource getResource() {
        return this.getModelResource().getResource();
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        return this.getResource();
    }

    public IPath getPath() {
        return this.getModelResource().getPath();
    }

    public boolean hasChildren() throws ModelWorkspaceException {
        return false;
    }

    protected ModelBufferImpl getModelBuffer() throws ModelWorkspaceException {
        ModelResourceImpl modelResourceImpl = (ModelResourceImpl)this.getModelResource();
        return (ModelBufferImpl)modelResourceImpl.getBuffer();
    }

    public List getTransformations(EObject target) throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getTransformations(target);
    }

    public List getTransformations() throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getTransformations();
    }

    public SqlTransformationMappingRoot createNewSqlTransformation(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewSqlTransformationMappingRoot(target, this.getModelResource().getEmfResource());
    }

    public FragmentMappingRoot createNewFragmentMapping(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewFragmentMappingRoot(target, this.getModelResource().getEmfResource());
    }

    public TreeMappingRoot createNewTreeMapping(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewTreeMappingRoot(target, this.getModelResource().getEmfResource());
    }

    public TransformationMappingRoot addNewTransformation(EObject target, TransformationMappingRoot newMappingRoot) throws ModelWorkspaceException {
        TransformationContainer tc = ModelResourceContainerFactory.getTransformationContainer(this.getModelResource().getEmfResource(), true);
        newMappingRoot.setTarget(target);
        if (newMappingRoot != null) {
            try {
                ModelerCore.getModelEditor().addValue(tc, newMappingRoot, tc.getTransformationMappings());
            }
            catch (ModelerCoreException err) {
                ModelerCore.Util.log(4, err, ModelerCore.Util.getString(CREATE_TRANSFORMATION_ERROR, target));
            }
        }
        return newMappingRoot;
    }

    public boolean delete(TransformationMappingRoot transformation) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.deleteTransformation(transformation);
    }

    public Openable getOpenable() {
        return this.getOpenableParent();
    }
}

