/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.validation;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.LRUCache;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.ValidationAspect;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationRule;
import com.metamatrix.modeler.core.validation.ValidationRuleSet;
import com.metamatrix.modeler.core.validation.rules.EObjectUuidRule;
import com.metamatrix.modeler.core.validation.rules.EmfResourceValidationRule;
import com.metamatrix.modeler.core.validation.rules.ModelFileExtensionRule;
import com.metamatrix.modeler.core.validation.rules.MultiplicityRule;
import com.metamatrix.modeler.core.validation.rules.ResourceInScopeValidationRule;
import com.metamatrix.modeler.core.validation.rules.TargetTransformationRule;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationRuleSetImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ValidationRuleManager {
    private static final ValidationRule MULTIPLICITY_RULE = new MultiplicityRule();
    private static final ValidationRule FILE_EXTENSION_RULE = new ModelFileExtensionRule();
    private static final ValidationRule TABLE_TRANFORMATION_RULE = new TargetTransformationRule();
    private static final ValidationRule EOBJECT_UUID_RULE = new EObjectUuidRule();
    private static final ValidationRule EMF_RESOURCE_RULE = new EmfResourceValidationRule();
    private static final ValidationRule RESOURCE_IN_SCOPE_RULE = new ResourceInScopeValidationRule();
    private LRUCache cache = new LRUCache();

    public void addRuleSet(EClass eClass, ValidationRuleSet ruleSet) {
        ArgCheck.isNotNull(eClass);
        ArgCheck.isNotNull(ruleSet);
        this.cache.put(eClass, ruleSet);
    }

    public void addRuleSet(Resource eResource, ValidationRuleSet ruleSet) {
        ArgCheck.isNotNull(eResource);
        ArgCheck.isNotNull(ruleSet);
        this.cache.put(eResource.getClass(), ruleSet);
    }

    public ValidationRuleSet getRuleSet(Object object, ValidationContext context) {
        Class<?> key;
        ValidationRuleSet ruleSet = null;
        if (object instanceof EObject) {
            ValidationAspect validationAspect = AspectManager.getValidationAspect((EObject)object);
            if (validationAspect != null) {
                validationAspect.updateContext((EObject)object, context);
            }
            if (validationAspect == null || validationAspect.shouldValidate((EObject)object, context)) {
                EClass key2 = ((EObject)object).eClass();
                ruleSet = (ValidationRuleSet)this.cache.get(key2);
                if (ruleSet == null) {
                    if (validationAspect != null) {
                        ruleSet = validationAspect.getValidationRules();
                    }
                    if (ruleSet == null) {
                        ruleSet = new ValidationRuleSetImpl();
                    }
                    this.addCoreRules(ruleSet);
                    this.addRuleSet(key2, ruleSet);
                }
            } else if (ModelerCore.DEBUG_VALIDATION) {
                ModelerCore.Util.log(1, "Excluding from validation:" + object);
            }
        } else if (object instanceof Resource && (ruleSet = (ValidationRuleSet)this.cache.get(key = object.getClass())) == null) {
            ruleSet = new ValidationRuleSetImpl();
            this.addResourceRules((Resource)object, ruleSet);
            this.addRuleSet((Resource)object, ruleSet);
        }
        return ruleSet;
    }

    private void addCoreRules(ValidationRuleSet ruleSet) {
        ruleSet.addRule(RESOURCE_IN_SCOPE_RULE);
        ruleSet.addRule(MULTIPLICITY_RULE);
        ruleSet.addRule(EOBJECT_UUID_RULE);
    }

    private void addResourceRules(Resource eResource, ValidationRuleSet ruleSet) {
        if (eResource instanceof EmfResource) {
            ruleSet.addRule(FILE_EXTENSION_RULE);
            ruleSet.addRule(TABLE_TRANFORMATION_RULE);
            ruleSet.addRule(EMF_RESOURCE_RULE);
        } else if (eResource instanceof XSDResourceImpl) {
            // empty if block
        }
    }
}

