/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.validation;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ValidationResultImpl
implements ValidationResult {
    private static final ValidationProblem[] EMPTY_ARRAY = new ValidationProblem[0];
    private boolean hasInitialized = false;
    private boolean isFatalObj = false;
    private boolean isFatalResource = false;
    private ObjectVector problems;
    private String locationPath;
    private String locationUri;
    private String targetUri;
    private Object target;
    private Object location;

    public ValidationResultImpl(Object target) {
        this(target, null);
    }

    public ValidationResultImpl(Object target, Object location) {
        this.target = target;
        this.location = location;
    }

    public Object getTarget() {
        return this.target;
    }

    public boolean isFatalObject(Object eObject) {
        if (eObject != null && eObject.equals(this.target)) {
            return this.isFatalObj;
        }
        return false;
    }

    public boolean isFatalResource() {
        return this.isFatalResource;
    }

    public ValidationProblem[] getProblems() {
        if (this.problems != null && this.problems.size != 0) {
            Object[] result = new ValidationProblem[this.problems.size];
            this.problems.copyInto(result);
            return result;
        }
        return EMPTY_ARRAY;
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size > 0;
    }

    public void addProblem(ValidationProblem problem) {
        if (problem != null) {
            boolean bl = this.isFatalObj = problem.getSeverity() == 4;
            if (this.problems == null) {
                this.problems = new ObjectVector(1);
            }
            this.problems.add(problem);
            this.init(this.target, this.location);
        }
    }

    public String getLocationPath() {
        return this.locationPath;
    }

    public void setLocationPath(String locationPath) {
        ArgCheck.isNotNull(locationPath);
        this.locationPath = locationPath;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public void setFatalResource(boolean fatal) {
        this.isFatalResource = fatal;
    }

    private void init(Object target, Object location) {
        if (!this.hasInitialized) {
            this.initTarget(target);
            if (target != location) {
                this.initLocation(location);
            }
            this.hasInitialized = true;
        }
    }

    private void initTarget(Object target) {
        ArgCheck.isNotNull(target);
        this.target = target;
        if (target instanceof EObject) {
            EObject eObj = (EObject)target;
            this.targetUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (this.locationPath == null) {
                this.locationPath = ((Object)ModelerCore.getModelEditor().getModelRelativePath(eObj)).toString();
            }
            if (this.locationUri == null) {
                this.locationUri = this.targetUri;
            }
        } else if (target instanceof Resource) {
            this.targetUri = null;
            this.locationPath = ModelerCore.getModelEditor().getModelName((Resource)target);
            this.locationUri = null;
        } else if (target instanceof IResource) {
            this.targetUri = null;
            this.locationPath = ((Object)((IResource)target).getFullPath()).toString();
            this.locationUri = null;
        }
    }

    private void initLocation(Object location) {
        if (location instanceof EObject) {
            EObject eObj = (EObject)location;
            this.locationPath = ((Object)ModelerCore.getModelEditor().getModelRelativePath(eObj)).toString();
            this.locationUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (this.targetUri == null) {
                this.targetUri = this.locationUri;
            }
        } else if (location instanceof Resource) {
            this.locationPath = ModelerCore.getModelEditor().getModelName((Resource)location);
            this.locationUri = null;
        } else if (this.target instanceof IResource) {
            this.targetUri = null;
            this.locationPath = ((Object)((IResource)this.target).getFullPath()).toString();
            this.locationUri = null;
        }
    }

    public String toString() {
        if (this.hasProblems()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getLocationPath());
            sb.append('\n');
            ValidationProblem[] problems = this.getProblems();
            for (int i2 = 0; i2 != problems.length; ++i2) {
                ValidationProblem problem = problems[i2];
                sb.append(problem.toString());
                sb.append('\n');
            }
            return sb.toString();
        }
        return "";
    }
}

