/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.transaction;

import com.metamatrix.core.id.LongIDFactory;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.transaction.Undoable;
import com.metamatrix.modeler.core.transaction.UndoableListener;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.transaction.UnitOfWorkProvider;
import com.metamatrix.modeler.internal.core.transaction.UnitOfWorkImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class UnitOfWorkProviderImpl
implements UnitOfWorkProvider {
    private static final boolean DEBUG = false;
    private static final HashMap current = new HashMap();
    private final ResourceSet resources;
    private final Collection undoableListeners;
    private static LongIDFactory idFactory = new LongIDFactory();

    public UnitOfWorkProviderImpl(ResourceSet resources) {
        if (resources == null) {
            Assertion.isNotNull(resources, ModelerCore.Util.getString("UnitOfWorkProviderImpl.ResourceSet_may_not_be_null_during_SimpleEmfUnitOfWorkProvider_construction_1"));
        }
        this.resources = resources;
        this.undoableListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitOfWork getCurrent() {
        UnitOfWork uow = null;
        HashMap hashMap = current;
        synchronized (hashMap) {
            Iterator threads = current.entrySet().iterator();
            while (threads.hasNext()) {
                Map.Entry entry = threads.next();
                if (entry.getKey() == Thread.currentThread()) {
                    uow = (UnitOfWork)entry.getValue();
                    if (!uow.isComplete()) continue;
                    uow = null;
                    continue;
                }
                if (((Thread)entry.getKey()).isAlive()) continue;
                threads.remove();
            }
            if (uow == null) {
                uow = new UnitOfWorkImpl(this.resources);
                current.put(Thread.currentThread(), uow);
            }
        }
        return uow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Thread thread) {
        HashMap hashMap = current;
        synchronized (hashMap) {
            current.remove(thread);
        }
    }

    public void addUndoableEditListener(UndoableListener listener) {
        if (!this.undoableListeners.contains(listener)) {
            this.undoableListeners.add(listener);
        }
    }

    public void removeUndoableEditListener(UndoableListener listener) {
        if (this.undoableListeners.contains(listener)) {
            this.undoableListeners.remove(listener);
        }
    }

    public synchronized void processUndoable(Undoable undoable) {
        Iterator listeners = this.undoableListeners.iterator();
        while (listeners.hasNext()) {
            UndoableListener next = (UndoableListener)listeners.next();
            next.process(undoable);
        }
    }

    public static LongIDFactory getIdFactory() {
        return idFactory;
    }

    public static void setIdFactory(LongIDFactory factory) {
        idFactory = factory;
    }
}

